AJS.test.require('com.pyxis.greenhopper.jira:plan-chaperones', function() {
    var PlanChaperones;
    var PlanOnboarding;
    var HelpTip;
    var planChaperones;

    try {
        PlanChaperones = require('jira-agile/onboarding/chaperones/plan-chaperones');
    } catch (e) {
        AJS.log('Was not able to load the resource, likely testing on an old version of JIRA');
    }

    module('Plan Chaperones tests', {
        setup: function() {
            if (PlanChaperones) {
                HelpTip = {
                    show: sinon.spy(),
                    dismiss: sinon.spy(),
                    refresh: sinon.spy()
                };
                AJS.$('#qunit-fixture').append('<div class="js-add-sprint aui-button-primary"></div>');
                //AJS.$('#qunit-fixture').append('<meta name="ajs-onboarding-has-completed-first-use-flow" content="true" />');
                AJS.Meta.set('onboarding-has-completed-first-use-flow', true);
                this.clock = sinon.useFakeTimers();
                sinon.stub(AJS, 'HelpTip').returns(HelpTip);
                PlanOnboarding = {};
                GH.Events(PlanOnboarding);
                planChaperones = new PlanChaperones(PlanOnboarding);
            }
        },
        teardown: function() {
            if (PlanChaperones) {
                AJS.HelpTip.restore();
                this.clock.restore();
            }
        }
    });

    //As these qunit tests cannot be put in dynamic module it must be included in all versions of JIRA, therefore,
    //It will try and run it in versions of JIRA which are not possible. If it does, do not fail these tests.
    if (!PlanChaperones) {
        test('Make sure there is at least one test for JIRA versions < 6.4', sinon.test(function () {
            ok(true);
        }));
    } else {

        test('chaperone shown', function () {
            ok(!HelpTip.show.called);
            PlanOnboarding.trigger('refresh');
            ok(HelpTip.show.calledOnce);
            ok(true);
        });

        test('chaperone shown just once when refresh called multiple times', function () {
            ok(!HelpTip.show.called);
            PlanOnboarding.trigger('refresh');
            ok(HelpTip.show.calledOnce);
            PlanOnboarding.trigger('refresh');
            ok(HelpTip.show.calledOnce);
        });

        test('helptip refresh called after the first call to refresh', function () {
            PlanOnboarding.trigger('refresh');
            ok(HelpTip.show.calledOnce);
            ok(!HelpTip.refresh.called);
            PlanOnboarding.trigger('refresh');
            ok(HelpTip.refresh.calledOnce);
        });

        test('chaperone not shown when first flow not completed', function () {
            AJS.Meta.set('onboarding-has-completed-first-use-flow', false);
            PlanOnboarding.trigger('refresh');
            ok(!HelpTip.show.called);
        });

        test('dismiss chaperone when anchor is clicked', function () {
            PlanOnboarding.trigger('refresh');
            ok(!HelpTip.dismiss.called);
            AJS.$('.js-add-sprint.aui-button-primary').click();
            this.clock.tick(0);
            ok(HelpTip.dismiss.calledOnce);
            sinon.assert.calledWith(HelpTip.dismiss, 'dismissed');
        });

        test('chaperone not dismissed when not shown', function () {
            ok(!HelpTip.dismiss.called);
            PlanOnboarding.trigger('refresh');
            ok(!HelpTip.dismiss.called);
        });

        test('chaperones can handle help tip undefined', sinon.test(function () {
            var HelpTip = AJS.HelpTip;
            delete AJS.HelpTip;
            PlanOnboarding.trigger('refresh');
            _.each(planChaperones.chaperones, function(chaperone) {
                ok(typeof chaperone.popup === 'undefined');
            });
            PlanOnboarding.trigger('refresh');
            AJS.HelpTip = HelpTip;
        }));

    }
});

