/* global AJS */
define('jira-agile/onboarding/chaperones/plan-chaperones', ['jquery', 'underscore'], function ($, _) {

    var PlanChaperones = function PlanChaperones(planOnboarding) {
        this.chaperones = [{
            id: 'create-sprint',
            title: AJS.I18n.getText('gh.onboarding.create.sprint.chaperone.title'),
            bodyHtml: AJS.I18n.getText('gh.onboarding.create.sprint.chaperone.message'),
            anchorSelector: '.js-add-sprint.aui-button-primary'
        }, {
            id: 'start-sprint',
            title: AJS.I18n.getText('gh.onboarding.start.sprint.chaperone.title'),
            bodyHtml: AJS.I18n.getText('gh.onboarding.start.sprint.chaperone.message'),
            anchorSelector: '.js-sprint-start.aui-button-primary'
        }];

        planOnboarding.on('refresh', onRefresh, this);
    };

    /**
     * Refresh elements (usually due to change in layout).
     */
    function onRefresh() {
        _.each(this.chaperones, function (chaperone) {
            if (typeof chaperone.helptip !== 'undefined') {
                chaperone.helptip.refresh();
            } else if ($(chaperone.anchorSelector).length) {
                this._initChaperone(chaperone);
            }
        }, this);
    }

    function hasCompletedFirstUseFlow() {
        return AJS.Meta.getBoolean('onboarding-has-completed-first-use-flow');
    }

    PlanChaperones.prototype._initChaperone = function (chaperone) {
        if (AJS.HelpTip && hasCompletedFirstUseFlow()) {
            if (typeof chaperone.helptip === 'undefined') {
                chaperone.helptip = new AJS.HelpTip({
                    id: 'onboarding-' + chaperone.id,
                    title: chaperone.title,
                    bodyHtml: chaperone.bodyHtml,
                    anchor: chaperone.anchorSelector,
                    showCloseButton: true
                });
                chaperone.helptip.show({ force: true });
                $(document).on('click.planChaperone', chaperone.anchorSelector, _.bind(function () {
                    this._dismissChaperone(chaperone);
                }, this));
            }
        }
    };

    PlanChaperones.prototype._dismissChaperone = function (chaperone) {
        if (typeof chaperone.helptip !== 'undefined') {
            chaperone.helptip.dismiss('dismissed');
            delete chaperone.helptip;
            $(document).off('click.planChaperone', chaperone.anchorSelector);
        }
    };

    return PlanChaperones;
});