GH.Test = GH.Test || {};

GH.Test.WizardDialog = {};

GH.Test.WizardDialog.getCurrentPage = function () {
    return AJS.$(".dialog-components:visible");
};

GH.Test.WizardDialog.getCurrentTitle = function () {
    return GH.Test.WizardDialog.getCurrentPage().find(".dialog-title").text();
};

/**
 * Not strictly speaking part of the dialog,
 * but needed to start the wizard so included anyway ...
 */
GH.Test.WizardDialog.getCreateLink = function () {
    return AJS.$("#js-view-actions-list").find(".js-view-action-create");
};

GH.Test.WizardDialog.hasCreateLink = function () {
    return GH.Test.WizardDialog.getCreateLink().length == 1;
};

GH.Test.WizardDialog.createLinkIsEnabled = function () {
    return GH.Test.WizardDialog.hasCreateLink() && !GH.Test.WizardDialog.getCreateLink().hasClass("disabled");
};

GH.Test.WizardDialog.clickCreateLink = function () {
    GH.Test.WizardDialog.getCreateLink().click();
};

GH.Test.WizardDialog.getCreateButton = function () {
    return AJS.$(".js-view-action-create");
};

GH.Test.WizardDialog.hasCreateButton = function () {
    return GH.Test.WizardDialog.getCreateButton().length == 1;
};
GH.Test.WizardDialog.createButtonIsEnabled = function () {
    return GH.Test.WizardDialog.hasCreateButton() && !GH.Test.WizardDialog.getCreateButton().is(":disabled");
};

GH.Test.WizardDialog.createButtonIsDisabled = function () {
    return GH.Test.WizardDialog.hasCreateButton() && GH.Test.WizardDialog.getCreateButton().is(":disabled");
};

GH.Test.WizardDialog.clickCreateButton = function () {
    GH.Test.WizardDialog.getCreateButton().click();
};

GH.Test.WizardDialog.getDialog = function () {
    return AJS.$("#ghx-wizard-dialog");
};

GH.Test.WizardDialog.isVisible = function () {
    return GH.Test.WizardDialog.getDialog().length == 1;
};

/****************** WHICH SCREEN ARE WE ON? ********************/
/**
 * Return true if we are currently viewing the create project page
 * Test against the title of the dialog
 */
GH.Test.WizardDialog.displayingCreateProjectScreen = function () {
    return GH.Test.WizardDialog.getCurrentTitle() === "gh.wizard.heading.project.new";
};

/**
 * Return true if we are currently viewing the create project page
 * Test against the title of the dialog
 */
GH.Test.WizardDialog.displayingOptionsScreen = function () {
    return GH.Test.WizardDialog.getCurrentPage().find("#js-method-choice").is(":visible");
};

/**
 * Return true if we are currently viewing the choose a project
 * Test against the title of the dialog
 */
GH.Test.WizardDialog.displayingExistingProjectScreen = function () {
    return GH.Test.WizardDialog.getCurrentTitle() === "gh.wizard.heading.project.existing";
};

/****************** METHODOLOGY BUTTONS ********************/

GH.Test.WizardDialog.getScrumButton = function () {
    return GH.Test.WizardDialog.getDialog().find("#ghx-wizard-methodology-scrum");
};

GH.Test.WizardDialog.getScrumSampleDataButton = function () {
    return GH.Test.WizardDialog.getDialog().find("#ghx-wizard-methodology-scrum-sample");
};

GH.Test.WizardDialog.hasScrumButton = function () {
    return GH.Test.WizardDialog.getScrumButton().length == 1;
};

GH.Test.WizardDialog.hasScrumSampleDataButton = function () {
    return GH.Test.WizardDialog.getScrumSampleDataButton().length == 1;
};

GH.Test.WizardDialog.clickCreateScrumBoardLink = function () {
    GH.Test.WizardDialog.getScrumButton().click();
};

GH.Test.WizardDialog.clickCreateScrumWithSampleDataLink = function () {
    GH.Test.WizardDialog.getScrumSampleDataButton().click();
};

GH.Test.WizardDialog.getKanbanButton = function () {
    return GH.Test.WizardDialog.getDialog().find("#ghx-wizard-methodology-kanban");
};

GH.Test.WizardDialog.getKanbanSampleDataButton = function () {
    return GH.Test.WizardDialog.getDialog().find("#ghx-wizard-methodology-kanban-sample");
};

GH.Test.WizardDialog.clickCreateKanbanBoardLink = function () {
    GH.Test.WizardDialog.getKanbanButton().click();
};

GH.Test.WizardDialog.hasKanbanButton = function () {
    return GH.Test.WizardDialog.getKanbanButton().length == 1;
};

GH.Test.WizardDialog.hasKanbanSampleDataButton = function () {
    return GH.Test.WizardDialog.getKanbanSampleDataButton().length == 1;
};

/****************** OPTIONS ********************/

GH.Test.WizardDialog.getExistingProjectOption = function () {
    return GH.Test.WizardDialog.getCurrentPage().find("#ghx-wizard-method-existing-project");
};

GH.Test.WizardDialog.getNewProjectOption = function () {
    return GH.Test.WizardDialog.getCurrentPage().find("#ghx-wizard-method-new-project");
};

/**
 * Return true if there is a visible radio button for creating a board using an existing project
 * If this is not the current panel, or option is not present, return false
 */
GH.Test.WizardDialog.hasUseExistingProjectOption = function () {
    return GH.Test.WizardDialog.getExistingProjectOption().length == 1;
};

/**
 * Return true if there is a visible radio button for creating a board using a filter
 * If this is not the current panel, or option is not present, return false
 */
GH.Test.WizardDialog.hasUseExistingFilterOption = function () {
    var projectOption = GH.Test.WizardDialog.getCurrentPage().find("#ghx-wizard-method-existing-filter");
    return projectOption.length == 1;
};

/**
 * Return true if there is a visible radio button for creating a new project and board
 * If this is not the current panel, or option is not present, return false
 */
GH.Test.WizardDialog.hasCreateProjectOption = function () {
    var projectOption = GH.Test.WizardDialog.getCurrentPage().find("#ghx-wizard-method-new-project");
    return projectOption.length == 1;
};