AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-test-dates', 'com.pyxis.greenhopper.jira:gh-rapid'], function() {
    var BurndownChartModel = require('jira-agile/rapid/ui/chart/burndown-chart-model');
    var BurndownChartView = require('jira-agile/rapid/ui/chart/burndown-chart-view');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.trigger('pre-initialization');

    var startDate = new Date(2012, 10, 26).valueOf(); // Monday
    var endDate = new Date(2012, 11, 7).valueOf(); // Friday, 11 days later
    var startWeekend = new Date(2012, 11, 1).valueOf();
    var endWeekend = new Date(2012, 11, 3).valueOf();

    var workRates = {
        timezone: 'Australia/Sydney',
        rates: [
            { start: startDate, end: startWeekend, rate: 1 },
            { start: startWeekend, end: endWeekend, rate: 0 },
            { start: endWeekend, end: endDate, rate: 1 }
        ]
    };

    var noWorkRates = {
        timezone: 'Australia/Sydney',
        rates: [
            { start: startDate, end: startWeekend, rate: 0 },
            { start: startWeekend, end: endWeekend, rate: 0 },
            { start: endWeekend, end: endDate, rate: 0 }
        ]
    };

    var chartData = {
        statisticField : {
            typeId: 'field',
            fieldId: 'customfield_10002',
            id: 'field_customfield_10002',
            name:'Story Points',
            isValid:true,
            isEnabled:true,
            renderer:'number'
        },
        startTime: startDate,
        endTime: endDate,
        completeTime: endDate,
        changes: {},
        workRateData: workRates
    };

    // TODO: extend these tests to start from BurndownChartController.show and stub out ajax requests to return stubbed data above with more extensive checks

    // Test that the burndown chart code works as a whole to draw a chart with the options we expect
    module('Render Burndown Chart', {
        setup: function() {
            var stubbedFlotChart = {
                hooks: {
                    draw: [],
                    drawSeries: []
                }
            };
            sinon.stub(AJS.$, 'plot', function(placeholder, data, options) {
                options.xaxis.tickSize = 'day';
                return stubbedFlotChart;
            });
            if (_.isUndefined(GH.RapidViewConfig.currentData.data)) { GH.RapidViewConfig.currentData.data = {id: 1}; }
        },
        teardown: function() {
            AJS.$.plot.restore();
        }
    });

    test('Renders chart with non-working days', sinon.test(function() {
        QUnit.GhFixtures.addFixture('<div id="ghx-chart-view"><div class="legend"><table><tbody></tbody></table></div></div>');
        this.stub(GH.RapidBoard.State, 'getNonWorkingDaysShown').returns(true);

        BurndownChartModel.setRawData(chartData);
        BurndownChartView.setNonWorkingDaysShown(true);
        BurndownChartView.renderChart();

        // check that we tried to draw a chart
        ok(AJS.$.plot.called);

        var chartArgs = AJS.$.plot.firstCall.args;

        // check we passed the correct selector
        equal(chartArgs[0].selector, '#ghx-chart-view');

        // 3 series: burndown, guideline and non-working days (for legend only)
        var series = chartArgs[1];
        equal(series.length, 3);

        // check we show time
        var options = chartArgs[2];
        equal(options.xaxis.mode, 'time');

        // should contain markings
        ok(options.grid.markings);

        // should have drawn the checkbox for non-working days
        equal(AJS.$('#ghx-chart-show-non-working-days').length, 1);
    }));

    test('Renders chart without non-working days', sinon.test(function() {
        this.stub(GH.RapidBoard.State, 'getNonWorkingDaysShown').returns(false);

        BurndownChartModel.setRawData(chartData);
        BurndownChartView.setNonWorkingDaysShown(false);
        BurndownChartView.renderChart();

        // check that we tried to draw a chart
        ok(AJS.$.plot.called);

        var chartArgs = AJS.$.plot.firstCall.args;

        // check we passed the correct selector
        equal(chartArgs[0].selector, '#ghx-chart-view');

        // 3 series: burndown, guideline and non-working days (for legend only)
        var seriesForLegend = chartArgs[1];
        equal(seriesForLegend.length, 3);

        // check we show time
        var options = chartArgs[2];
        equal(options.xaxis.mode, 'time');

        // check axis are formatted correctly
        ok(options.xaxis.tickFormatter);

        // Validate formatting
        var date = new Date(Date.UTC(2012, 10, 19));
        equal(options.xaxis.tickFormatter(date.valueOf(), options.xaxis), 'Nov 19');

        // Ensure it takes account of current timezone
        date.setUTCHours(23);
        equal(options.xaxis.tickFormatter(date.valueOf(), options.xaxis), 'Nov 19');

        // should not contain any markings
        ok(!options.grid.markings);
    }));

    test('Renders error message instead of chart when no working days exist', sinon.test(function() {
        QUnit.GhFixtures.addFixture('<div id="ghx-chart-view"><div class="legend"><table><tbody></tbody></table></div></div>');

        this.stub(GH.RapidBoard.State, 'getNonWorkingDaysShown').returns(false);

        var noWorkRatesData = _.extend(chartData, {workRateData: noWorkRates});

        BurndownChartModel.setRawData(noWorkRatesData);
        BurndownChartView.renderChart();

        // check we did not try to draw the plot
        ok(!AJS.$.plot.called);

        // check we showed an error message
    }));
});
