(function () {

    var wrmContextPath = require('wrm/context-path');

    GH.QuickCreateIssueInEpic = {};
    GH.QuickCreateIssueInEpic.epicKey = null;
    GH.QuickCreateIssueInEpic.epicName = null;

    GH.QuickCreateIssueInEpic.init = function () {

        JIRA.unbind("QuickCreateIssueInEpic.sessionComplete");
        JIRA.bind("QuickCreateIssueInEpic.sessionComplete", function (e, issues) {
            AJS.$(document).unbind(JIRA.EpicPicker.READY_EVENT);
            GH.QuickCreateIssueInEpic.handleIssuesCreated(issues);
        });
    };

    GH.QuickCreateIssueInEpic.createQuickCreateIssueForEpicDialog = function () {

        GH.QuickCreateIssueInEpic.epicKey = AJS.$("#ghx-epic-key").text();
        GH.QuickCreateIssueInEpic.epicName = AJS.$("#ghx-epic-name").text();

        if (AJS.$("#ghx-hide-table").text() == 'true') {
            var table = AJS.$("#ghx-issues-in-epic-table");
            table.addClass("hidden");
        }

        // Copied from Quick Edit plugin to override the title
        var form = new JIRA.Forms.Container(function () {
            var options = {
                title: AJS.I18n.getText('gh.epic.operations.create.issue.in.epic.title', GH.QuickCreateIssueInEpic.epicKey),
                id: "create-issue-in-epic-form",
                globalEventNamespaces: ["QuickCreateIssueInEpic"]
            };

            // model that gets fields and sets user preferences
            var model = new JIRA.Forms.CreateIssueModel({
                projectId: options.pid,
                issueType: options.issueType
            }),
                configurableForm = new JIRA.Forms.ConfigurableCreateIssueForm({
                model: model,
                title: options.title,
                globalEventNamespaces: options.globalEventNamespaces
            }),
                unconfigurableForm = new JIRA.Forms.UnconfigurableCreateIssueForm({
                model: model,
                title: options.title,
                globalEventNamespaces: options.globalEventNamespaces
            });

            return {
                globalEventNamespaces: options.globalEventNamespaces,
                model: model,
                errorHandler: new JIRA.Forms.CreateIssueError(),
                configurableForm: configurableForm,
                unconfigurableForm: unconfigurableForm
            };
        });

        // init epic picker with preselected epic
        form.bind("contentRefreshed", function () {
            AJS.$(document).unbind("QuickCreateIssueInEpic.validationError");
            AJS.$(document).unbind(JIRA.EpicPicker.READY_EVENT);
            AJS.$(document).bind(JIRA.EpicPicker.READY_EVENT, function (e, epicPicker) {
                epicPicker.setSelection(new AJS.ItemDescriptor({
                    value: "key:" + GH.QuickCreateIssueInEpic.epicKey,
                    label: GH.QuickCreateIssueInEpic.epicName
                }));
                // ensure epic picker is disabled
                setTimeout(function () {
                    epicPicker.disable();
                }, 0);

                // after the form has a validation error, disable the epic picker
                AJS.$(document).bind("QuickCreateIssueInEpic.validationError", function (e) {
                    epicPicker.disable();
                });
            });
        });

        var dialog = form.asDialog({
            windowTitle: AJS.I18n.getText('gh.epic.operations.create.issue.in.epic.title', GH.QuickCreateIssueInEpic.epicKey),
            id: "create-issue-dialog"
            //        trigger: "#gh-create-issue-in-epic-lnk"
        });

        dialog.bind('Dialog.hide', function () {
            AJS.$(document).unbind(JIRA.EpicPicker.READY_EVENT);
            AJS.$(document).unbind("QuickCreateIssueInEpic.validationError");
        });

        return dialog;
    };

    GH.QuickCreateIssueInEpic.handleIssuesCreated = function (issues) {
        var issueKeys = _.pluck(issues, "issueKey");

        // Ensure issues are added to the epic. If the epic link field was not present on the dialog, this will ensure the link does get established.
        GH.QuickCreateIssueInEpic.addIssuesToEpic(issues).done(function () {
            GH.QuickCreateIssueInEpic.refreshIssuesInEpicTable(issueKeys);
        });
    };

    GH.QuickCreateIssueInEpic.addIssuesToEpic = function (issues) {
        var issueKeys = _.pluck(issues, "issueKey");

        var addToEpicRequest = {
            ignoreEpics: true,
            issueKeys: issueKeys
        };

        // add issues to epic
        return GH.Ajax.put({
            url: '/epics/' + GH.QuickCreateIssueInEpic.epicKey + '/add',
            data: addToEpicRequest
        });
    };

    GH.QuickCreateIssueInEpic.refreshIssuesInEpicTable = function (issueKeys) {
        var $module = AJS.$("#greenhopper-epics-issue-web-panel");
        $module.addClass("updating");

        AJS.$.ajax({
            url: wrmContextPath() + "/secure/ViewIssuesInEpic.jspa?epicKey=" + GH.QuickCreateIssueInEpic.epicKey + "&decorator=none"
        }).done(function (html) {
            // replace issues in epic table html
            $module.find(".mod-content").html(html);
            // initialize issue actions cog
            JIRA.Dropdowns.bindIssueActionsDds($module);
            // highlight the newly created issues
            AJS.$.each(issueKeys, function (i, issueKey) {
                $module.find(".issuerow[data-issuekey='" + issueKey + "']").fadeInBackground();
            });

            var $table = AJS.$("#ghx-issues-in-epic-table");
            var hideTable = AJS.$("#ghx-hide-table").text() == 'true';
            if (hideTable) {
                $table.addClass("hidden");
            } else {
                AJS.$("#ghx-issues-in-epic-empty-message").remove();
                $table.removeClass("hidden");
            }
            $module.removeClass("updating");
        });
    };
})();

AJS.$(function () {
    // init on page loaded
    GH.QuickCreateIssueInEpic.init();

    // init on ajax page load
    JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, context, reason) {
        if (reason === JIRA.CONTENT_ADDED_REASON.pageLoad) {
            GH.QuickCreateIssueInEpic.init();
        }
    });

    // delegate click handler for create issue in epic link
    AJS.$(document).undelegate("#gh-create-issue-in-epic-lnk", "click");
    AJS.$(document).delegate("#gh-create-issue-in-epic-lnk", "click", function (e) {
        var dialog = GH.QuickCreateIssueInEpic.createQuickCreateIssueForEpicDialog();
        dialog.show();
        e.preventDefault();
    });
});