AJS.test.require(['com.pyxis.greenhopper.jira:gh-rapid', 'com.pyxis.greenhopper.jira:subnavigator-test'], function() {
    AJS.namespace('JIRA.API.Projects');
    AJS.namespace('JIRA.API.Sidebar');
    AJS.namespace('JIRA.Projects.Sidebar');

    var reportSubnavigatorContextProvider;
    var mockReportControls = {
        rapidViewConfig: {
            name: "board name"
        }
    };

    var context = AJS.test.mockableModuleContext();

    context.mock('jira-agile/rapid/ui/chart/report-controller', mockReportControls);
    reportSubnavigatorContextProvider = context.require('jira-agile/subnavigator/report-subnavigator-context-provider');

    module('ReportSubnavigatorContextProvider.tests', {
        setup: function() {
            JIRA.API.Projects.getCurrentProjectKey = function() {};
            JIRA.API.Sidebar.isProjectSidebar = function() {};
            JIRA.API.getSidebar = function() {
                return new AJS.$.Deferred().resolve(JIRA.API.Sidebar).promise();
            };
            JIRA.Projects.Sidebar.Reports = {
                storeLastViewedReportLink: function() {}
            };

            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(GH.ReportController, 'selectChart');
            this.sandbox.stub(GH.ReportController, 'getSelectedChart');
            this.sandbox.stub(GH.ReportController, 'getApplicableCharts');
            this.sandbox.stub(JIRA.API.Sidebar, 'isProjectSidebar');
            this.sandbox.stub(JIRA.Projects.Sidebar.Reports, 'storeLastViewedReportLink');
            this.sandbox.stub(JIRA.API.Projects, 'getCurrentProjectKey');

            JIRA.API.Projects.getCurrentProjectKey.returns('SSP');

            this.originalReportControllerRapidViewData = GH.ReportController.rapidViewData;
            GH.ReportController.rapidViewData = {
                id: '23'
            };
        },
        teardown: function() {
            this.sandbox.restore();
            GH.ReportController.rapidViewData = this.originalReportControllerRapidViewData;
        }
    });

    test('Should delegate to report controller when an item is selected', function() {
        JIRA.API.Sidebar.isProjectSidebar.returns(true);

        GH.RapidBoard.ReportSubnavigatorContextProvider.selectionHandler('itemId');

        sinon.assert.calledOnce(GH.ReportController.selectChart);
        sinon.assert.calledWith(GH.ReportController.selectChart, 'itemId');
        sinon.assert.calledOnce(JIRA.Projects.Sidebar.Reports.storeLastViewedReportLink);
    });

    test('Should delegate to report controller to query the selected item', function() {
        GH.ReportController.getSelectedChart.returns('chartId');

        var selectedItemId = GH.RapidBoard.ReportSubnavigatorContextProvider.selectedItem();

        equal(selectedItemId, 'chartId');
    });

    test('Should query all available reports from report controller', function() {
        JIRA.API.Sidebar.isProjectSidebar.returns(false);

        GH.ReportController.getApplicableCharts.returns([{
            id: 'report1',
            name: 'Report 1',
            tooltip: 'Description for report1'
        }, {
            id: 'report2',
            name: 'Report 2',
            tooltip: 'Description for report2'
        }]);

        var items = GH.RapidBoard.ReportSubnavigatorContextProvider.itemList();
        deepEqual(items,[{
            id: 'report1',
            label: 'Report 1',
            description: 'Description for report1'
        }, {
            id: 'report2',
            label: 'Report 2',
            description: 'Description for report2'
        }]);
    });

    test('Should append all reports option when in project sidebar', function() {
        JIRA.API.Sidebar.isProjectSidebar.returns(true);

        GH.ReportController.getApplicableCharts.returns([{
            id: 'report1',
            name: 'Report 1',
            tooltip: 'Description for report1'
        }, {
            id: 'report2',
            name: 'Report 2',
            tooltip: 'Description for report2'
        }]);

        var groups = GH.RapidBoard.ReportSubnavigatorContextProvider.itemList();
        equal(groups.length, 2);

        deepEqual(groups[0],[{
            id: 'report1',
            label: 'Report 1',
            description: 'Description for report1'
        }, {
            id: 'report2',
            label: 'Report 2',
            description: 'Description for report2'
        }]);

        equal(groups[1].length, 1);
        equal(groups[1][0].id, 'com.atlassian.jira.jira-projects-plugin:report-page');

    });

    test('Should remember current report on load', function() {
        var storeLastViewedReportLinkStub = this.stub( GH.RapidBoard.ReportSubnavigatorContextProvider, '_storeLastViewedReportLink');
        GH.ReportController.getSelectedChart.returns('reportId');

        GH.RapidBoard.ReportSubnavigatorContextProvider.onLoad();

        sinon.assert.calledOnce(storeLastViewedReportLinkStub);
        sinon.assert.calledWith(storeLastViewedReportLinkStub, 'reportId');

        storeLastViewedReportLinkStub.restore();
    });

    test('Should not call JIRA projects API when store last viewed report link is invoked and the board is viewed in a project context and the store API does not exist', function() {
        JIRA.API.Sidebar.isProjectSidebar.returns(true);
        JIRA.Projects.Sidebar.Reports = undefined;

        GH.RapidBoard.ReportSubnavigatorContextProvider._storeLastViewedReportLink('burndownChart');

        expect(0); //Happy as long as we're not failing due to undefined.
    });

    test('Should call JIRA projects API when store last viewed report link is invoked and the board is viewed in a project context', function() {
        JIRA.API.Sidebar.isProjectSidebar.returns(true);

        GH.RapidBoard.ReportSubnavigatorContextProvider._storeLastViewedReportLink('burndownChart');

        sinon.assert.calledOnce(JIRA.Projects.Sidebar.Reports.storeLastViewedReportLink);
        sinon.assert.calledWith(JIRA.Projects.Sidebar.Reports.storeLastViewedReportLink, AJS.contextPath() + '/secure/RapidBoard.jspa?rapidView=23&projectKey=SSP&view=reporting&chart=burndownChart&useStoredSettings=true');
    });

    test('Should do nothing when store last viewed report link is invoked and the board is viewed in a global context', function() {
        GH.RapidBoard.ReportSubnavigatorContextProvider._storeLastViewedReportLink('burndownChart');

        sinon.assert.notCalled(JIRA.Projects.Sidebar.Reports.storeLastViewedReportLink);
    });

    test('header should be board name', function() {
        var boardName = mockReportControls.rapidViewConfig.name;
        var header = reportSubnavigatorContextProvider.header();

        equal(header, boardName, 'Expected header to be board name');
    });
});
