AJS.test.require('com.pyxis.greenhopper.jira:gh-rapid', function() {
    const WorkView = require('jira-agile/rapid/ui/work/work-view');

    module('WorkView', {
        renderIssue: function(id, key, summary) {
            var displayIssueKeys = {};
            displayIssueKeys[key] = key;
            return GH.tpl.rapid.swimlane.renderIssue({
                issue: {
                    id: id,
                    key: key,
                    summary: summary
                },
                displayIssueKeys: displayIssueKeys,
                selectedIssueKeys: {}
            });
        },

        renderThrobber: function renderThrobber() {
            var throbber = AJS.$('<div class="ghx-throbber"></div>');
            AJS.$('#qunit-fixture').append(throbber);
        },

        findSpinners: function findSpinners() {
            return AJS.$('.ghx-throbber').find('.spinner');
        }
    });

    test('getIssueKeyDimensions returns available width of first visible issue', function() {
        var pool = AJS.$('<div id="ghx-pool"></div>');
        var hiddenIssue = AJS.$(this.renderIssue(1, 'ABC-1', 'Hidden issue')).hide();
        var visibleIssue = AJS.$(this.renderIssue(2, 'ABC-2', 'Visible issue'));
        pool.append(hiddenIssue).append(visibleIssue);
        AJS.$('#qunit-fixture').append(pool);

        var issueKeyDimensions = WorkView.getIssueKeyDimensions();
        ok(issueKeyDimensions.availableWidth > 0);
        ok(issueKeyDimensions.approxCharacterWidth > 0);
    });

    test('showKanPlanAcknowledge: show KanPlan acknowledge when mode is Kanban', function() {
        GH.RapidViewConfig.currentData.data = {
            sprintSupportEnabled: false
        };

        this.stub(WorkView, "showKanPlanAcknowledge");

        WorkView.show();

        ok(WorkView.showKanPlanAcknowledge.called, "Show KanPlan acknowledge when mode is KanBan");
    });

    test('should show a spinner when showing pool', function shouldShowASpinnerWhenShowingPool() {
        this.renderThrobber();

        WorkView.hideLoadingPool();
        WorkView.showLoadingPool();

        ok(this.findSpinners().length === 1);
    });

    test('should not show a spinner when hiding pool', function shouldNotShowASpinnerWhenHidingPool() {
        this.renderThrobber();

        WorkView.showLoadingPool();
        WorkView.hideLoadingPool();

        ok(this.findSpinners().length === 0);
    });
});

