define('jira-agile/rapid/ui/work/work-url-state', ["jira-agile/rapid/ui/work/work-selection-controller", "jira-agile/rapid/work/work-controls", "jira-agile/rapid/ui/work/work-controller"], function (WorkSelectionController, WorkControls, WorkController) {
    "use strict";
    /**
     * Manages the url state for the work tab
     */

    var WorkUrlState = {};

    WorkUrlState.self = "WorkUrlState";

    /**
     * Is this state applicable for the given normalized state
     * @param normalized
     */
    WorkUrlState.isApplicable = function (normalized) {
        return !normalized.mode || normalized.mode === 'work';
    };

    /**
     * Normalizes the url state for the plan specific values.
     * @param urlParams the parsed url parameters
     * @param normalized normalized parameters
     */
    WorkUrlState.getNormalizedFromUrl = function (urlParams, normalized) {
        // selected issue
        normalized['selectedIssue'] = GH.RapidBoard.UrlState.normalizeStringParam(urlParams['selectedIssue'], null); // null by default

        // sprint
        normalized['sprint'] = GH.RapidBoard.UrlState.normalizeNumberArrayParam(urlParams['sprint']); // empty by default

        // quick filter
        normalized['quickFilter'] = GH.RapidBoard.UrlState.normalizeNumberArrayParam(urlParams['quickFilter']); // empty by default
    };

    /**
     * Transforms the normalized url parameters into actual url parameters
     * @param normalized the normalized params
     * @param urlParams the url params
     */
    WorkUrlState.toUrl = function (normalized, urlParams) {
        // selected issue
        if (normalized['selectedIssue']) {
            urlParams['selectedIssue'] = normalized['selectedIssue'];
        }

        // sprints
        if (normalized['sprint'].length > 0) {
            urlParams['sprint'] = normalized['sprint'];
        }

        // filters
        if (normalized['quickFilter'].length > 0) {
            urlParams['quickFilter'] = normalized['quickFilter'];
        }
    };

    /**
     * Get the normalized state from the app
     * @param normalized the normalized state to put the values into
     */
    WorkUrlState.getNormalizedFromInternal = function (normalized) {
        WorkController.init();
        // quick filter
        normalized['quickFilter'] = WorkControls.getActiveQuickFilterIds(); // always fetch quick filters, even none are active

        // quick filter
        normalized['sprint'] = WorkControls.getActiveSprintIds(); // always fetch quick filters, even none are active

        // selected issue
        normalized['selectedIssue'] = WorkSelectionController.getSelectedIssueKey();
    };

    /**
     * Update the app with the values stored in the normalized state
     * @param normalized the normalized state to update the values from
     */
    WorkUrlState.updateInternalFromNormalized = function (normalized) {
        var urlParams = GH.RapidBoard.UrlState.getCurrentUrlState();
        var useStoredSettings = GH.RapidBoard.UrlState.normalizeBooleanParam(urlParams['useStoredSettings'], false);

        WorkController.init();
        if (!useStoredSettings) {
            WorkSelectionController.setIssueFromUrlState(normalized['selectedIssue']); // always set the value
            WorkControls.setActiveQuickFilterIds(normalized['quickFilter']);
            WorkControls.setActiveSprintFilterIds(normalized['sprint']);
        }
    };

    return WorkUrlState;
});

AJS.namespace('GH.WorkUrlState', null, require('jira-agile/rapid/ui/work/work-url-state'));