define('jira-agile/rapid/ui/work/swimline-stalker', [
    "jira-agile/rapid/ui/work/grid-data-controller",
    "jira-agile/rapid/ui/work/swimlane-view-text",
    "jquery",
    'underscore'
], function(
    GridDataController,
    SwimlaneViewText,
    $,
    _
) {
    "use strict";
    /**
     * Keeps the column headers and swimlane label in place when scrolling further down the page.
     *
     * When modifying this, take the following situations into account:
     *
     * - stalker bar has to resize on window width change
     * - swimlane label has to change on scroll
     * - stalker has to reposition when changing in and out of projector mode (Z-key)
     * - swimlane label should not show if there is only one lane
     * - column statistics change the position
     * - swimlanes can be collapsed
     */
    const SwimlaneStalker = {};

    /**
     * Holds the value for the column head offset
     */
    //SwimlaneStalker.colHeadOffset = null;
    //SwimlaneStalker.colHeadProjectorOffset = null;

    /**
     * Bind the events to scroll/resize. We don't use a delay here since it would make the UI choppy.
     */
    SwimlaneStalker.init = function () {
    };

    /**
     * Stalker for work mode pool headers
     */
    SwimlaneStalker.headerHeight = 0;
    SwimlaneStalker.poolStalker = function () {

        // check if there is a header
        var $colHeaderGroup = $('#ghx-column-header-group');
        if ($colHeaderGroup.length > 0) {

            var $pool = $('#ghx-pool');
            var $poolPos = $pool.offset();
            var $poolWidth = $pool.find('.ghx-columns').width();
            var $poolPadding = parseInt($pool.css('padding-left'), 10);

            var colHeaderHeight = $colHeaderGroup.outerHeight(); // different header names + constraints shown may be different heights

            $colHeaderGroup
                .addClass('ghx-fixed')
                .css({
                    'position': 'fixed',
                    'top': $poolPos.top,
                    'left': $poolPos.left + $poolPadding,
                    'width': $poolWidth
                });
            $pool.css({'padding-top': colHeaderHeight}); // space for the header to be fixed

            SwimlaneStalker.headerHeight = colHeaderHeight;

            // register swimlane stalker
            SwimlaneStalker.registerSwimlaneStalker();
        }

    };

    SwimlaneStalker.registerSwimlaneStalker = function () {
        $('#ghx-pool').unbind('scroll.swimlaneStalker').bind('scroll.swimlaneStalker', SwimlaneStalker.updateSwimlaneHeaderStalker);
    };

    SwimlaneStalker.updateSwimlaneHeaderStalker = function () {
        // fetch stalker
        var $swimlaneHeaderContainer = $('#js-swimlane-header-stalker');

        // how far have we scrolled?
        var poolPosition = $("#ghx-pool").scrollTop();

        // only add swimlane stalker if we scrolled
        if (!poolPosition) {
            $swimlaneHeaderContainer.hide();
            return;
        }
        $swimlaneHeaderContainer.show();

        // 1. do we need a swimlane header?
        var swimlanes = $('.ghx-swimlane-header');
        if (!swimlanes.length) {
            return;
        }

        // 2. which swimlane do we show
        var firstVisibleSwimlane = undefined;
        _.each(swimlanes, function (swimlane) {
            swimlane = $(swimlane);
            if (swimlane.position().top <= SwimlaneStalker.headerHeight) {
                firstVisibleSwimlane = swimlane;
            } else {
                return false;
            }
        });
        if (!firstVisibleSwimlane) {
            return;
        }

        // 3. copy swimlane header
        var $copy = firstVisibleSwimlane.clone();
        $copy.find('.js-expander').remove();

        $swimlaneHeaderContainer.empty().append($copy);
    };

    SwimlaneStalker.updateStalkerContent = function (swimlaneId) {
        // fetch all required data
        var swimname = $('#ghx-swimname');
        var model = GridDataController.getModel();
        var swimlane = model.getSwimlaneById(swimlaneId);
        var issueCount = model.getSwimlaneIssueCount(swimlaneId);

        // set the summary and icon
        var parentData = swimlane.parentKey ? GridDataController.getModel().getIssueDataByKey(swimlane.parentKey) : false;
        if (parentData) {
            if (parentData.done) {
                swimname.addClass('ghx-done');
            } else {
                swimname.removeClass('ghx-done');
            }
            swimname.find('.ghx-summary').text(parentData.summary);
            swimname.find('.ghx-type').html('<img height="16" width="16" src="' + parentData.typeUrl + '">')
                .attr('title', parentData.typeName);
        } else {
            swimname.removeClass('ghx-done');
            swimname.find('.ghx-summary').empty();
            swimname.find('.ghx-type').empty();
        }

        // set the name + count + tooltip
        swimname.find('.ghx-name').text(swimlane.name);
        swimname.find('.ghx-qty').text(SwimlaneViewText.getIssueCountLabel(swimlane, issueCount));
        var swimlaneTitle = SwimlaneViewText.getSwimlaneTitle(swimlane, issueCount);
        swimname.find('.ghx-name, .ghx-qty, .ghx-summary').attr('title', swimlaneTitle);
    };

    SwimlaneStalker.refreshStalkerContent = function () {
        var swimname = $('#ghx-swimname');
        if (!swimname.visible()) {
            return;
        }

        var swimlaneId = parseInt(swimname.attr('data-swimlane-id', swimlaneId), 10);
        SwimlaneStalker.updateStalkerContent(swimlaneId);
    };

    return SwimlaneStalker;
});

AJS.namespace('GH.SwimlaneStalker', null, require('jira-agile/rapid/ui/work/swimline-stalker'));