AJS.test.require('com.pyxis.greenhopper.jira:gh-rapid', function () {
    var SplitIssueAction = require('jira-agile/rapid/ui/plan/contextmenu/split-issue-action');

    var ZERO_ISSUE_CTX = {
        selectedIssues: [],
        currentModel: {}
    };

    var SINGLE_ISSUE_IN_BACKLOG_CTX = {
        selectedIssues: ['ISS-1'],
        currentModel: {}
    };

    var SUBTASKS_SELECTED_CTX = {
        selectedIssues: ['ISS-15', 'ISS-16'],
        currentModel: {},
        hasSubtasks: true
    };

    var MULTIPLE_ISSUES_CTX = {
        selectedIssues: ['ISS-1', 'ISS-2'],
        currentModel: {}
    };

    var SINGLE_ISSUE_IN_FUTURE_SPRINT_CTX = {
        selectedIssues: ['ISS-1'],
        currentModel: {
            sprintData: {
                state: 'FUTURE'
            }
        }
    };

    var SINGLE_ISSUE_IN_ACTIVE_SPRINT_CTX = {
        selectedIssues: ['ISS-1'],
        currentModel: {
            sprintData: {
                state: 'ACTIVE'
            }
        }
    };

    module('Split issue menu item tests', {
        setup: function setup() {
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(GH.Features.SPLIT_ISSUE, 'isEnabled');
            this.sandbox.stub(GH.RapidBoard.State, 'isPlanMode');

            GH.Features.SPLIT_ISSUE.isEnabled.withArgs().returns(true);
            GH.RapidBoard.State.isPlanMode.withArgs().returns(true);
        },

        teardown: function teardown() {
            this.sandbox.restore();
        }
    });

    test('Should not append split issue menu item when no issue is selected', function () {
        var actionGroups = [];

        SplitIssueAction.appendMenuItem(ZERO_ISSUE_CTX, actionGroups);

        equal(actionGroups.length, 0);
    });

    test('Should not append split issue menu item when subtasks are selected', function () {
        var actionGroups = [];

        SplitIssueAction.appendMenuItem(SUBTASKS_SELECTED_CTX, actionGroups);

        equal(actionGroups.length, 0);
    });

    test('Should not append split issue menu item when multiple issues are selected', function () {
        var actionGroups = [];

        SplitIssueAction.appendMenuItem(MULTIPLE_ISSUES_CTX, actionGroups);

        equal(actionGroups.length, 0);
    });

    test('Should append split issue menu item into its own group in an empty collection of action groups when a single issue in the backlog is selected', function () {
        var actionGroups = [];

        SplitIssueAction.appendMenuItem(SINGLE_ISSUE_IN_BACKLOG_CTX, actionGroups);

        ok(splitIssueActionGroupIsAdded(actionGroups));
    });

    test('Should append split issue menu item into its own group in a non-empty collection of action groups when a single issue in the backlog is selected', function () {
        var actionGroups = [{}, {}, {}];

        SplitIssueAction.appendMenuItem(SINGLE_ISSUE_IN_BACKLOG_CTX, actionGroups);

        ok(splitIssueActionGroupIsAdded(actionGroups));
    });

    test('Should append split issue menu item into its own group when a single issue in a future sprint is selected', function () {
        var actionGroups = [];

        SplitIssueAction.appendMenuItem(SINGLE_ISSUE_IN_FUTURE_SPRINT_CTX, actionGroups);

        ok(splitIssueActionGroupIsAdded(actionGroups));
    });

    test('Should append split issue menu item into its own group when a single issue in an active sprint is selected', function () {
        var actionGroups = [];

        SplitIssueAction.appendMenuItem(SINGLE_ISSUE_IN_ACTIVE_SPRINT_CTX, actionGroups);

        ok(splitIssueActionGroupIsAdded(actionGroups));
    });

    test('Should not append split issue menu item when a single issue in a future sprint is selected and dark feature is disabled', function () {
        GH.Features.SPLIT_ISSUE.isEnabled.withArgs().returns(false);
        var actionGroups = [];

        SplitIssueAction.appendMenuItem(SINGLE_ISSUE_IN_FUTURE_SPRINT_CTX, actionGroups);

        equal(actionGroups.length, 0);
    });

    function splitIssueActionGroupIsAdded(actionGroups) {
        var finalGroup = actionGroups[actionGroups.length - 1];
        if (!finalGroup || !finalGroup.actions || finalGroup.actions.length !== 1) {
            return false;
        }
        var action = finalGroup.actions[0];
        return action && action.id === 'ghx-issue-ctx-action-split-issue';
    }
});