AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    var $ = require('jquery');
    var SprintBacklogView = require('jira-agile/rapid/ui/plan/sprint-backlog-view');
    var BacklogModel2 = require('jira-agile/rapid/ui/plan/backlog-model2');
    var BacklogModel = require('jira-agile/rapid/ui/plan/backlog-model');
    var IssueListModel = require('jira-agile/rapid/ui/plan/issue-list-model');

    test('SprintBacklogView module exists', function () {
        ok(SprintBacklogView);
        ok(GH.SprintBacklogView);
    });

    test('Epic label should appear on backlog issues', function () {
        QUnit.GhFixtures.addFixture("<div class='ghx-backlog-group'></div>");

        var epicKey = 'TEST';
        var issues = GH.IssueTest.createArrayOfIssues(2);
        var issueKey1 = issues[0].key;
        var issueKey2 = issues[1].key;
        issues[0].epic = epicKey;
        var epics = [GH.IssueTest.createIssueObject({ key: epicKey, 'epicLabel': 'TEST Epic' })];

        var mockEpicModel = new GH.EpicModel();
        mockEpicModel.epicsList = new IssueListModel('test', epics, null);
        this.stub(GH.EpicController, 'getEpicModel').returns(mockEpicModel);

        var sprintModel = new BacklogModel2(issues);
        this.stub(BacklogModel, 'getBacklogModel2').returns(sprintModel);

        var issueRenderData = { hiddenIssues: {}, selectedIssueKeys: {} };
        SprintBacklogView.renderBacklog(issueRenderData);

        ok($('.js-issue[data-issue-key=' + issueKey1 + ']').find('span[data-epickey=' + epicKey + ']').length > 0);
        ok($('.js-issue[data-issue-key=' + issueKey2 + ']').find('span[data-epickey=' + epicKey + ']').length === 0);
    });
});