/* global GH */

/**
 * @module jira-agile/rapid/ui/plan/plan-controls
 * @requires module:jquery
 */
define('jira-agile/rapid/ui/plan/plan-controls', ['require'], function(require) {

    var $ = require('jquery');

    var PlanControls = {};

    PlanControls.rapidViewConfig = {};

    /**
     * Holds the quick filters component
     */
    PlanControls.quickfilters = undefined;

    /**
     * Holds the search filter component
     */
    PlanControls.searchFilter = undefined;

    PlanControls.init = function () {
        // create the quick filters component
        PlanControls.quickfilters = new GH.Components.QuickFilters('planQuickFilters');

        // create the search filter component
        PlanControls.searchFilter = new GH.Components.SearchFilter(GH.BacklogController.executeSearch);

    };

    PlanControls.setRapidViewConfig = function (rapidViewConfig) {
        PlanControls.rapidViewConfig = rapidViewConfig;

        PlanControls.quickfilters.setRapidViewConfig(rapidViewConfig);
    };

    PlanControls.renderControls = function () {
        var $planControls = $('#ghx-controls-plan');
        $planControls.empty();

        // render the quick filters
        $planControls.append(PlanControls.quickfilters.renderQuickFilters({mode: 'plan'}));

        // render the search filter
        $planControls.append(PlanControls.searchFilter.render());

        // render the presentation mode button
        GH.PresentationMode.render(true, $planControls);

        // update visibility of certain view actions
        GH.ViewActions.setMode(GH.ViewActions.PLAN_MODE);
    };

    PlanControls.stopEdits = function () {
        PlanControls.searchFilter.stopEdit($('#ghx-controls-plan'));
    };

    PlanControls.resizeQuickFilters = function () {
        PlanControls.quickfilters.quickExpanderLayout({mode: 'plan'});
    };

    return PlanControls;
});