AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid", function () {
    var BacklogSelectionController = require('jira-agile/rapid/ui/plan/backlog-selection-controller');
    var PlanController = require('jira-agile/rapid/ui/plan/plan-controller');

    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.trigger('pre-initialization');

    var BacklogModel = require('jira-agile/rapid/ui/plan/backlog-model');
    var PlanControls = require('jira-agile/rapid/ui/plan/plan-controls');
    var $ = require('jquery');

    module('PlanController tests', {
        setup: function () {
            this.clock = sinon.useFakeTimers();

            // data for ScrumBase and KanPlanBase decide if it can handle the data or not
            GH.RapidViewConfig.currentData.data = {
                sprintSupportEnabled: true
            };
        },
        teardown: function () {
            this.clock.restore();
        }
    });

    test("module 'jira-agile/rapid/ui/plan/plan-controller' exists", function () {
        ok(PlanController);
        ok(GH.PlanController);
    });

    test("epics column is set according to the previous board state", sinon.test(function () {

        GH.BoardState = GH.BoardState || {};

        this.stub(GH.BoardState, 'getPerViewValue');
        GH.BoardState.getPerViewValue.withArgs("planEpicsVisible").returns(true);
        ok(PlanController.isEpicsColumnVisible());

        GH.BoardState.getPerViewValue.withArgs("planEpicsVisible").returns(false);
        ok(!PlanController.isEpicsColumnVisible());

        // clean up
        GH.BoardState.getPerViewValue.restore();

    }));

    test("epics column defaults to false", sinon.test(function () {

        GH.BoardState = GH.BoardState || {};

        this.stub(GH.BoardState, 'getPerViewValue');
        GH.BoardState.getPerViewValue.withArgs("planEpicsVisible").returnsArg(1);

        ok(!PlanController.isEpicsColumnVisible());

        // clean up
        GH.BoardState.getPerViewValue.restore();
    }));

    test("versions panel is set according to the previous board state", sinon.test(function () {

        GH.BoardState = GH.BoardState || {};

        this.stub(GH.BoardState, 'getPerViewValue');
        GH.BoardState.getPerViewValue.withArgs("planVersionsVisible").returns(true);
        ok(PlanController.isVersionsColumnVisible());

        GH.BoardState.getPerViewValue.withArgs("planVersionsVisible").returns(false);
        ok(!PlanController.isVersionsColumnVisible());

        // clean up
        GH.BoardState.getPerViewValue.restore();
    }));

    test("versions panel defaults to false", sinon.test(function () {

        GH.BoardState = GH.BoardState || {};

        this.stub(GH.BoardState, 'getPerViewValue');
        GH.BoardState.getPerViewValue.withArgs("planVersionsVisible").returnsArg(1);

        ok(!PlanController.isVersionsColumnVisible());

        // clean up
        GH.BoardState.getPerViewValue.restore();
    }));

    test('Push state only if we actually open detail view', sinon.test(function () {
        this.spy(GH.RapidBoard.State, 'pushState');
        this.stub(GH.RapidBoard.State, 'isDetailsViewPlanOpened').returns(true);
        this.stub(BacklogSelectionController, 'getSelectedIssueKey').returns('key-1');
        this.stub(GH.DetailsView, 'show');

        PlanController.doUpdateDetailsView('key-1');
        this.clock.tick(100);

        ok(GH.RapidBoard.State.pushState.called);
    }));

    test("Do not push state if we don't open detail view", sinon.test(function () {
        this.spy(GH.RapidBoard.State, 'pushState');
        this.stub(GH.RapidBoard.State, 'isDetailsViewPlanOpened').returns(true);
        this.stub(BacklogSelectionController, 'getSelectedIssueKey').returns(null);
        this.stub(GH.DetailsView, 'show');

        PlanController.doUpdateDetailsView(null);
        this.clock.tick(100);

        ok(!GH.RapidBoard.State.pushState.called);
    }));

    module("PlanController.initializePlanMode tests", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.jiraAnalytics = require('jira/analytics');
            this.sandbox.stub(this.jiraAnalytics, "send");

            this.kanplanFeatureService = require('jira-agile/rapid/ui/kanplan/kan-plan-feature-service');
            this.sandbox.stub(this.kanplanFeatureService, "shouldShowEpicsPanel").returns(true);
            this.sandbox.stub(GH.RapidBoard.State, "getRapidViewId").returns("rapidViewId");

            GH.UserData.userConfig = {};
            GH.UserData.userConfig.isGlobalAdmin = false;
            PlanControls.init();
            this.data = {quickFilters: []};
            GH.PlanController.rapidViewData = {id: "rapidViewId"};
            GH.PlanController.isVisible = true;
            GH.PlanController.setRapidView(this.data);
            this.setBoardTypeToKanban();
            this.sandbox.stub(BacklogModel, "getBacklogModel2").returns(this.buildModel(3,2));
            this.sandbox.stub(BacklogModel, "getSprintModels").returns([this.buildModel(7,5)]);
            this.sandbox.stub(BacklogModel, "getAllIssueListsNew").returns([]);
            this.backlogControllerDeferred = $.Deferred();
            this.sandbox.stub(GH.BacklogController, "loadData").returns(this.backlogControllerDeferred.promise());

            GH.EpicController.model = {
                getEpicList: function () {
                    return {
                        getIssueCount: function () {
                            return 123;
                        }
                    };
                }
            };
        },

        buildModel: function (issueCount, issuesExcludingSubtasks) {
            return {
                getIssueList: function () {
                    return {
                        getIssueCount: function () {
                            return issueCount;
                        },
                        getIssuesExcludingSubtasks: function () {
                            return Array(issuesExcludingSubtasks);
                        }
                    };
                }
            }
        },

        teardown: function () {
            this.sandbox.restore();
        },

        setBoardTypeToKanban: function () {
            this.sandbox.stub(GH.RapidBoard.State, "getBoardType").returns("kanban");
            this.sandbox.stub(GH.RapidBoard.State, "isKanbanBoard").returns(true);
        },

        setBoardTypeToScrum: function () {
            this.sandbox.stub(GH.RapidBoard.State, "getBoardType").returns("scrum");
            this.sandbox.stub(GH.RapidBoard.State, "isKanbanBoard").returns(false);
        }
    });

    test("initializePlanMode should send analytics events for kanban boards", function () {
        ok(this.jiraAnalytics.send.notCalled, "Analytics should not be sent yet");

        GH.PlanController.initializePlanMode();

        ok(this.jiraAnalytics.send.notCalled, "Analytics should not be sent yet");

        this.backlogControllerDeferred.resolve(this.dataModel);

        ok(this.jiraAnalytics.send.calledOnce, "Method should be called on init");
        var args = this.jiraAnalytics.send.getCall(0).args[0];

        deepEqual(args, {
            name: 'jira-software.kanban.plan.view',
            properties: {
                boardType: "kanban",
                boardId: "rapidViewId",
                backlogIssueCount: 3,
                backlogSubtasksCount: 1,
                selectedForDevelopmentIssueCount: 7,
                selectedForDevelopmentSubtasksCount: 2,
                epicsPanelEnabled: true,
                epicsCount: 123,
                isVersionsFilterApplied:false,
                isEpicsFilterApplied:false
            }
        }, "Properties should be equal");
    });
});