AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common","com.pyxis.greenhopper.jira:gh-rapid"],function(){function e(e){return{key:e}}function s(e,s){return{key:s,parentKey:e}}var t=require("jira-agile/rapid/ui/plan/issue-list-model");module("IssueListModelTests"),test("module 'jira-agile/rapid/ui/plan/issue-list-model' exists",function(){ok(t),ok(GH.IssueListModel)}),test("Test visible issues",function(){var e=GH.IssueTest.issueObjectsFromKeys(["GHS-1","GHS-2","GHS-3"]),s={getVersionsForIds:function(){}},r=new t("test",e,s),a=r.getVisibleRankables();equal(a.length,3,"Expected 3 visible issues"),equal(a[0],"GHS-1","Expected GHS-1 in visible issues"),equal(a[1],"GHS-2","Expected GHS-2 in visible issues"),equal(a[2],"GHS-3","Expected GHS-3 in visible issues");var n=r.getIssueData("GHS-1");n.hidden=!0,r.updateIssue(n),equal(r.getVisibleRankables().length,2,"Expected 2 visible issues"),a=r.getVisibleRankables(),equal(a[0],"GHS-2","Expected GHS-2 in visible issues"),equal(a[1],"GHS-3","Expected GHS-3 in visible issues")}),test("Test issue validity",function(){var e=GH.IssueTest.issueObjectsFromKeys(["GHS-1","GHS-2","GHS-3"]),s=new t("test",e);equal(s.isIssueValid("GHS-1"),!0,"Expected issue was valid"),equal(s.isIssueValid("GHS-2"),!0,"Expected issue was valid"),equal(s.isIssueValid("GHS-3"),!0,"Expected issue was valid"),equal(s.isIssueValid("GHS-4"),!1,"Expected issue was invalid"),s.removeIssues(["GHS-1"]),equal(s.isIssueValid("GHS-1"),!1,"Expected issue was invalid")}),test("Test inserting rankable keys",function(){var e=GH.IssueTest.issueObjectsFromKeys(["GHS-1","GHS-2","GHS-3"]),s=new t("test",e);s.insertMarker(-5,"GHS-1"),equal(s.getRankableBeforeId("GHS-1"),!1,"expected GHS-1 was first"),equal(s.getRankableBeforeId(-5),"GHS-1","expected -5 was after GHS-1"),equal(s.getRankableBeforeId("GHS-2"),-5,"expected GHS-2 was after -5"),s.insertMarker(-4,!1),equal(s.getRankableBeforeId(-4),!1,"expected -4 was first"),equal(s.getRankableBeforeId("GHS-1"),-4,"expected GHS-1 was after -4"),equal(s.getRankableBeforeId(-5),"GHS-1","expected -5 was after GHS-1"),equal(s.getRankableBeforeId("GHS-2"),-5,"expected GHS-2 was after -5"),s.insertMarker(-6,"GHS-3"),equal(s.getRankableBeforeId(-4),!1,"expected -4 was first"),equal(s.getRankableBeforeId("GHS-1"),-4,"expected GHS-1 was after -4"),equal(s.getRankableBeforeId(-5),"GHS-1","expected -5 was after GHS-1"),equal(s.getRankableBeforeId("GHS-2"),-5,"expected GHS-2 was after -5"),equal(s.getRankableBeforeId("GHS-3"),"GHS-2","expected GHS-3 was after GHS-2"),equal(s.getRankableBeforeId(-6),"GHS-3","expected -6 was after GHS-3"),s.insertMarker(-6,"GHS-2"),equal(s.getRankableBeforeId(-4),!1,"expected -4 was first"),equal(s.getRankableBeforeId("GHS-1"),-4,"expected GHS-1 was after -4"),equal(s.getRankableBeforeId(-5),"GHS-1","expected -5 was after GHS-1"),equal(s.getRankableBeforeId("GHS-2"),-5,"expected GHS-2 was after -5"),equal(s.getRankableBeforeId(-6),"GHS-2","expected -6 was after GHS-2"),equal(s.getRankableBeforeId("GHS-3"),-6,"expected GHS-3 was after -6")}),test("Test issue validity",function(){var e=GH.IssueTest.issueObjectsFromKeys(["GHS-1","GHS-2","GHS-3"]),s=new t("test",e);equal(s.areIssuesValid(["GHS-1"]),!0),equal(s.areIssuesValid(["GHS-1","GHS-2"]),!0),equal(s.areIssuesValid(["GHS-1","GHS-2","GHS-3"]),!0),equal(s.areIssuesValid(["GHS-1","GHS-2","GHS-3","GHS-4"]),!1),equal(s.areIssuesValid(["GHS-4"]),!1),equal(s.areIssuesValid([]),!1)}),test("Test canAddToSelection",function(){var e=GH.IssueTest.issueObjectsFromKeys(["GHS-1","GHS-2","GHS-3"]);e[0].hidden=!0;var s=new t("test",e);equal(s.canAddToSelection([],"GHS-2"),!0),equal(s.canAddToSelection(["GHS-1"],"GHS-2"),!1,"Expected false because GHS-1 is hidden"),equal(s.canAddToSelection(["GHS-2"],"GHS-1"),!1,"Expected false because GHS-1 is hidden"),equal(s.canAddToSelection(["GHS-2"],"GHS-3"),!0),equal(s.canAddToSelection(["GHS-4"],"GHS-2"),!1,"Expected false because GHS-4 is not part of the list")}),test("Test applySearchFilter",function(){var e=GH.IssueTest.issueObjectsFromKeys(["GHS-1","GHS-2","GHS-3"]);e[0].hidden=!0;var s=new t("test",e),r=function(e){return!0},a=s.applySearchFilter(r);equal(a,!1,"Expected no changes");var n=function(e){return!1};a=s.applySearchFilter(n),equal(a,!0,"Expected changes"),equal(s.isIssueVisible("GHS-1"),!1,"Expected GHS-1 is hidden"),equal(s.isIssueHiddenBySearchByKey("GHS-2"),!0,"Expected GHS-2 is hidden"),equal(s.isIssueVisible("GHS-2"),!1,"Expected GHS-2 is hidden"),equal(s.isIssueHiddenBySearchByKey("GHS-3"),!0,"Expected GHS-3 is hidden"),equal(s.isIssueVisible("GHS-3"),!1,"Expected GHS-3 is hidden");var i=function(e){return/3/.test(e.key)};a=s.applySearchFilter(i),equal(a,!0,"Expected changes"),equal(s.isIssueVisible("GHS-1"),!1,"Expected GHS-1 is hidden"),equal(s.isIssueHiddenBySearchByKey("GHS-2"),!0,"Expected GHS-2 is hidden"),equal(s.isIssueVisible("GHS-2"),!1,"Expected GHS-2 is hidden"),equal(s.isIssueHiddenBySearchByKey("GHS-3"),!1,"Expected GHS-3 is shown"),equal(s.isIssueVisible("GHS-3"),!0,"Expected GHS-3 is shown")}),test("Test getFirstRankableIssueKeyInColumn",function(){var e=new t("test",GH.IssueTest.issueObjectsFromKeys(["GHS-3","GHS-2","GHS-1","GHS-4","GHS-5"]));strictEqual(e.getFirstRankableIssueKeyInColumn(null),"GHS-3","handles null"),strictEqual(e.getFirstRankableIssueKeyInColumn("GHS-3"),"GHS-2","handles string"),strictEqual(e.getFirstRankableIssueKeyInColumn(["GHS-1","GHS-2"]),"GHS-3","handles array"),strictEqual(e.getFirstRankableIssueKeyInColumn(["GHS-1","GHS-2","GHS-3"]),"GHS-4","handles array")}),test("Test getFirstRankableIssueKeyInColumn with subtasks",function(){var e=new t("test",GH.IssueTest.issueObjects([{parentKey:"GHS-PARENT",key:"GHS-SUBTASK"},"GHS-3","GHS-2","GHS-1","GHS-4","GHS-5"]));strictEqual(e.getFirstRankableIssueKeyInColumn([],!0),"GHS-PARENT","useParentIssue is true so parent is used"),strictEqual(e.getFirstRankableIssueKeyInColumn([],!1),"GHS-SUBTASK","useParentIssue is false so subtask is used")}),test("Test getLastRankableIssueKeyInColumn",function(){var e=new t("test",GH.IssueTest.issueObjectsFromKeys(["GHS-3","GHS-2","GHS-1","GHS-4","GHS-5"]));strictEqual(e.getLastRankableIssueKeyInColumn(null),"GHS-5","handles null"),strictEqual(e.getLastRankableIssueKeyInColumn("GHS-5"),"GHS-4","handles string"),strictEqual(e.getLastRankableIssueKeyInColumn(["GHS-1","GHS-4"]),"GHS-5","handles array"),strictEqual(e.getLastRankableIssueKeyInColumn(["GHS-1","GHS-4","GHS-5"]),"GHS-2","handles array")}),test("Test getLastRankableIssueKeyInColumn with subtasks",function(){var e=new t("test",GH.IssueTest.issueObjects(["GHS-3","GHS-2","GHS-1","GHS-4","GHS-5",{parentKey:"GHS-PARENT",key:"GHS-SUBTASK"}]));strictEqual(e.getLastRankableIssueKeyInColumn([],!0),"GHS-PARENT","useParentIssue is true so parent is used"),strictEqual(e.getLastRankableIssueKeyInColumn([],!1),"GHS-SUBTASK","useParentIssue is false so subtask is used")}),test("Test areIssuesBetweenMarkers",function(){var e=new t("test",GH.IssueTest.issueObjectsFromKeys(["GHS-3","GHS-2","GHS-1","GHS-4","GHS-5"]));e.insertMarker(1,"GHS-3"),e.insertMarker(2,"GHS-4"),ok(e.areIssuesBetweenMarkers(["GHS-2","GHS-1","GHS-4"],1,2)),ok(e.areIssuesBetweenMarkers(["GHS-2","GHS-1","GHS-4"],2,1)),ok(e.areIssuesBetweenMarkers(["GHS-2","GHS-4"],1,2)),ok(e.areIssuesBetweenMarkers(["GHS-2","GHS-1"],1,2)),ok(e.areIssuesBetweenMarkers(["GHS-1"],1,2)),ok(!e.areIssuesBetweenMarkers(["GHS-3","GHS-2","GHS-1","GHS-4"],1,2)),ok(!e.areIssuesBetweenMarkers(["GHS-3","GHS-2","GHS-1","GHS-4","GHS-5"],1,2)),ok(!e.areIssuesBetweenMarkers(["GHS-3","GHS-5"],1,2)),ok(!e.areIssuesBetweenMarkers(["GHS-4","GHS-5"],1,2)),ok(!e.areIssuesBetweenMarkers(["GHS-4","GHS-5"],88,99))}),test("Test getMarkerBeforeId",function(){var e=new t("test",GH.IssueTest.issueObjectsFromKeys(["GHS-3","GHS-2","GHS-1","GHS-4","GHS-5"]));e.insertMarker(0,!1),e.insertMarker(1,"GHS-3"),e.insertMarker(2,"GHS-4"),e.insertMarker(3,"GHS-5"),strictEqual(e.getMarkerIdBeforeId(1),0,"Expected marker 0 to be returned"),strictEqual(e.getMarkerIdBeforeId(2),1,"Expected marker 1 to be returned"),strictEqual(e.getMarkerIdBeforeId(3),2,"Expected marker 2 to be returned"),ok(!e.getMarkerIdBeforeId(0))}),test("Test getIssueCount",function(){var e=new t("test",GH.IssueTest.issueObjectsFromKeys(["GHS-3","GHS-2","GHS-1","GHS-4","GHS-5"]));e.insertMarker(0,!1),e.insertMarker(1,"GHS-3"),e.insertMarker(2,"GHS-4"),e.insertMarker(3,"GHS-5"),strictEqual(e.getIssueCount(),5,"Expected an issue count of 5")}),test("Test getLastMarkerId",function(){var e=new t("test",GH.IssueTest.issueObjectsFromKeys(["GHS-3","GHS-2","GHS-1","GHS-4","GHS-5"]));e.insertMarker(0,!1),e.insertMarker(1,"GHS-3"),e.insertMarker(2,"GHS-4"),e.insertMarker(3,"GHS-5"),strictEqual(e.getLastMarkerId(),3,"Expected the last marker id to be 3")}),test("Test getMarkerIds",function(){var e=new t("test",GH.IssueTest.issueObjectsFromKeys(["GHS-3","GHS-2","GHS-1","GHS-4","GHS-5"]));e.insertMarker(0,!1),e.insertMarker(1,"GHS-3"),e.insertMarker(2,"GHS-4"),strictEqual(e.getMarkerIds().length,3,"Expected 3 markers to be returned"),e.insertMarker(3,"GHS-5"),strictEqual(e.getMarkerIds().length,4,"Expected 4 markers to be returned"),deepEqual(e.getMarkerIds(),[0,1,2,3],"Expected an array with marker ids [0,1,2,3]")}),module("IssueListModel reorderIssues",{setup:function(){var r=[e("P-1"),s("P-1","S-2"),s("P-1","S-3"),e("P-4"),e("P-5"),s("P-5","S-6"),e("P-7"),s("P-8","S-9")],a=new t("test-model",r),n=void 0,i=void 0,u=[];this.given={},this.given.userRanksIssues=function(e){return u=e,{beforeIssue:function(e){return i=e},afterIssue:function(e){return n=e}}},this.when={},this.when.rankingPerformed=function(){return a.reorderIssues(u,n,i)},this.verify={},this.verify.issueOrderIs=function(e,s){var t=a.getIssuesInOrder().map(function(e){return e.key});return deepEqual(t,e,s)}}}),test("can move issue after another issue",function(){this.given.userRanksIssues(["P-4"]).afterIssue("P-7"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-1","S-2","S-3","P-5","S-6","P-7","P-4","S-9"],"Expected P-4 to be moved to after P-7")}),test("can move issue before another issue",function(){this.given.userRanksIssues(["P-7"]).beforeIssue("P-4"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-1","S-2","S-3","P-7","P-4","P-5","S-6","S-9"],"Expected P-7 to be moved to before P-4")}),test("moving parent with rankBefore moves children",function(){this.given.userRanksIssues(["P-5"]).beforeIssue("P-4"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-1","S-2","S-3","P-5","S-6","P-4","P-7","S-9"],"Expected P-5 and children to be ranked before P-4")}),test("moving parent with rankAfter moves children",function(){this.given.userRanksIssues(["P-1"]).afterIssue("P-4"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-4","P-1","S-2","S-3","P-5","S-6","P-7","S-9"],"Expected P-1 and children to be ranked after P-4")}),test("moving parent with rankAfter inserts after children of rankAfter parent",function(){this.given.userRanksIssues(["P-1"]).afterIssue("P-5"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-4","P-5","S-6","P-1","S-2","S-3","P-7","S-9"],"Expected P-1 and children to be ranked after P-5 and children")}),test("can move a parent after an orphaned sub-task",function(){this.given.userRanksIssues(["P-7"]).afterIssue("P-8"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-1","S-2","S-3","P-4","P-5","S-6","S-9","P-7"],"Expected P-7 to be ranked after S-9, the orphan child of P-8")}),test("can move a parent before an orphaned sub-task",function(){this.given.userRanksIssues(["P-1"]).beforeIssue("P-8"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-4","P-5","S-6","P-7","P-1","S-2","S-3","S-9"],"Expected P-1 and children to be ranked before S-9, the orphan child of P-8")}),test("can move sub-task after another in the same parent",function(){this.given.userRanksIssues(["S-2"]).afterIssue("S-3"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-1","S-3","S-2","P-4","P-5","S-6","P-7","S-9"],"Expected S-3 to be ranked above S-2")}),test("can move sub-task before another in the same parent",function(){this.given.userRanksIssues(["S-3"]).beforeIssue("S-2"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-1","S-3","S-2","P-4","P-5","S-6","P-7","S-9"],"Expected S-2 to be ranked below S-3")}),test("ignores selected subTasks and just moves all parents with children when ranking against a parent",function(){this.given.userRanksIssues(["P-1","S-2","S-3","P-5","S-6","S-9"]).beforeIssue("P-4"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-1","S-2","S-3","P-5","S-6","P-4","P-7","S-9"],"Expected S-9 to not move, and P-1, P-5 (with children) to be ranked before P-4")}),test("ignores unselected subTasks in a multi-select and still moves all children, when ranking against a parent",function(){this.given.userRanksIssues(["P-1","S-3"]).afterIssue("P-4"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-4","P-1","S-2","S-3","P-5","S-6","P-7","S-9"],"Expected P-1 and all children to be ranked after P-4")}),test("ignores selected parents in a multi-select, and just moves subTasks, when ranking against another subTask",function(){this.given.userRanksIssues(["S-3","P-4"]).beforeIssue("S-2"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-1","S-3","S-2","P-4","P-5","S-6","P-7","S-9"],"Expected S-3 to be ranked before S-2, and P-4 to not be moved.")}),test("ignores subTasks from a different parent in a multi-select, and only moves subTasks that are siblings of the ranked against subTask",function(){this.given.userRanksIssues(["S-3","S-6"]).beforeIssue("S-2"),this.when.rankingPerformed(),this.verify.issueOrderIs(["P-1","S-3","S-2","P-4","P-5","S-6","P-7","S-9"],"Expected S-3 to be ranked before S-2, and P-6 to not be moved.")}),module("getIssuesExcludingSubtasks"),test("getIssuesExcludingSubtasks() should exclude subTasks",function(){var e=new t("model",[GH.IssueTest.createIssueObject({id:1,hidden:!1}),GH.IssueTest.createIssueObject({id:2,hidden:!1,parentId:1}),GH.IssueTest.createIssueObject({id:3,hidden:!0})]),s=e.getIssuesExcludingSubtasks();equal(s.length,2)})});