define('jira-agile/rapid/ui/plan/analytics-helper', [
    'underscore',
    'require'
], function(
    _,
    require
) {
    var AnalyticsHelper = {};

    var GlobalEvents = require('jira-agile/rapid/global-events');
    var KanPlanFeatureService = require('jira-agile/rapid/ui/kanplan/kan-plan-feature-service');
    var BacklogModel;
    var IssueMoveController;


    // Resolve circular dependency
    GlobalEvents.on("pre-initialization", function () {
        BacklogModel = require('jira-agile/rapid/ui/plan/backlog-model');
        IssueMoveController = require('jira-agile/rapid/ui/plan/issue-move-controller');
    });


    AnalyticsHelper.baseEventData = function () {
        const DEFAULT_EPICS_COUNT = -1;

        var totalIssues = _.reduce(BacklogModel.getAllIssueListsNew(), function (start, model) {
            return start + model.getIssueCount();
        }, 0);

        var model2 = BacklogModel.getBacklogModel2();
        if (!model2) {
            return {};
        }
        var backlogModelIssueList = model2.getIssueList();

        var data = {
            boardType: GH.RapidBoard.State.getBoardType(),
            backlogIssueCount: backlogModelIssueList.getIssueCount(),
            boardId: GH.RapidBoard.State.getRapidViewId()
        };

        if (GH.RapidBoard.State.isKanbanBoard()) {
            data.backlogSubtasksCount = data.backlogIssueCount - backlogModelIssueList.getIssuesExcludingSubtasks().length;

            var selectedForDevModel = _.first(BacklogModel.getSprintModels());
            if (_.isUndefined(selectedForDevModel)) { // Something wrong
                return data;
            }
            data.selectedForDevelopmentIssueCount = selectedForDevModel.getIssueList().getIssueCount();
            data.selectedForDevelopmentSubtasksCount = data.selectedForDevelopmentIssueCount - selectedForDevModel.getIssueList().getIssuesExcludingSubtasks().length;
            data.epicsPanelEnabled = KanPlanFeatureService.shouldShowEpicsPanel();
            data.isVersionsFilterApplied = KanPlanFeatureService.isVersionsFilterApplied();
            data.isEpicsFilterApplied = KanPlanFeatureService.isEpicsFilterApplied();
        } else {
            data.totalIssueCount = totalIssues;
        }

        data.epicsCount = DEFAULT_EPICS_COUNT;
        if (GH.EpicController && GH.EpicController.getEpicModel() && GH.EpicController.getEpicModel().getEpicList()) {
            data.epicsCount = GH.EpicController.getEpicModel().getEpicList().getIssueCount();
        }

        return data;
    };

    AnalyticsHelper.getColumnName = function (isBacklog) {
        return isBacklog ? 'backlog' : 'selectedForDev';
    };

    AnalyticsHelper.getSrcColumnName = function (issueMoveModel) {
        return AnalyticsHelper.getColumnName(IssueMoveController.isSourceBacklog(issueMoveModel));
    };

    AnalyticsHelper.getDestColumnName = function (issueMoveModel) {
        return AnalyticsHelper.getColumnName(IssueMoveController.isTargetBacklog(issueMoveModel));
    };


    return AnalyticsHelper;
});
