/* global GH.Dialog, AJS.I18n */

define('jira-agile/rapid/ui/kanplan/kan-plan-dialog-utils', [
    'jquery',
    'underscore',
    'jira-agile/rapid/events'
], function(
    $,
    _,
    Events
) {
    'use strict';
    var KanPlanDialogUtils = {};

    KanPlanDialogUtils.createTransitionStatusDialog = function(transitions, targetColumnName, numIssues) {
        // 'text' escapes the value of targetColumnName, so we are XSS-safe
        var targetColumnNameHtml = $('<span/>', {'text': targetColumnName, 'class': 'column-name'}).get(0).outerHTML;

        return createConfirmationDialog({
            // height will be set automatically
            width: 500,
            id: 'ghx-kanplan-transition-status',
            header: AJS.I18n.getText('gh.rapid.config.kanplan.transition.status.header'),
            message: GH.tpl.kanplan.dialogutils.transitionStatusContent({
                transitions: transitions,
                targetColumnNameHtml: targetColumnNameHtml,
                numIssues: numIssues
            }),
            submitButton: AJS.I18n.getText('gh.rapid.config.kanplan.transition.status.choose'),
            cancelLink: AJS.I18n.getText('gh.rapid.config.kanplan.transition.status.cancel'),
            getSubmitModel: function () {
                var $checkedStatus = $('#ghx-kanplan-transition-status input[name=status]:checked');
                return $checkedStatus.attr("id");
            }
        });
    };

    function createConfirmationDialog(options) {
        var dialog = GH.Dialog.create({
            width: options.width,
            id: options.id,
            onCancelFn: function() {
                dialog.trigger('cancel');
            }
        });
        new Events(dialog);

        var $dialog = $('#'+dialog.id);
        $dialog.addClass('ghx-dialog');

        dialog.addHeader(options.header);
        dialog.addPanel('', 'panel');
        dialog.getCurrentPanel().html(options.message);
        dialog.addButton(
            options.submitButton,
            function() {
                var submitModel = {};
                if (_.isFunction(options.getSubmitModel)) {
                    submitModel = options.getSubmitModel();
                }

                dialog.disableControls();
                dialog.dispose();
                dialog.trigger('submit', submitModel);
            },'aui-button aui-button-primary'
        );
        if (!_.isUndefined(options.cancelLink)) {
            dialog.addCancel(options.cancelLink, function() {
                dialog.cancel(dialog);
            });
        }
        return dialog;
    }

    return KanPlanDialogUtils;
});
