AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common-base', 'com.pyxis.greenhopper.jira:gh-rapid'], function () {
    var KanPlanAcknowledge = require('jira-agile/rapid/ui/kanplan/kanplan-acknowledge');
    var KanPlanFeatureService = require('jira-agile/rapid/ui/kanplan/kan-plan-feature-service');

    module('KanPlanAcknowledge', {
        setup: function setup() {
            this.sandbox = sinon.sandbox.create();
            GH.Test.setUpFakeServer(this);
            if (!GH.UserData.userConfig) {
                GH.UserData.userConfig = {};
            }
            this.sandbox.stub(GH.HelpPaths, 'getHelpPath', function () {
                return {
                    url: 'http://someurl.com'
                };
            });

            this.hideStub = this.sandbox.stub(KanPlanAcknowledge, 'hide');

            this.sandbox.stub(GH.RapidBoard.State, 'isWorkMode', function () {
                return this.isWorkMode;
            }.bind(this));

            this.setModeStub = this.sandbox.stub(GH.RapidBoard.ViewController, 'setMode');

            this.handleResizeEventStub = this.sandbox.stub(GH.RapidBoard.ViewController, 'handleResizeEvent');

            this.server.respondWith('POST', '/jira/rest/greenhopper/1.0/xboard/plan/kanban/closeAcknowledge?mode=plan', [200, { 'Content-Type': 'application/json' }, '{}']);

            this.server.respondWith('POST', '/jira/rest/greenhopper/1.0/xboard/plan/kanban/closeAcknowledge?mode=work', [200, { 'Content-Type': 'application/json' }, '{}']);

            this.viewContainer = AJS.$('<div id="gh"></div>');
            AJS.$('#fancybox-tmp').append(this.viewContainer);
        },
        teardown: function teardown() {
            this.sandbox.restore();
            GH.Test.restoreServer(this);

            AJS.$('#fancybox-tmp').html('');
        }
    });

    /**
     *
     * This method is used to update the data retrieved by WRM data for the tests
     * @param data data to be set as acknowledgement banner user preference data
     */
    function updateAcknowledgementData(data) {
        KanPlanFeatureService.acknowledgeDisplayData = data;
    }

    test('show KanPlanAcknowledge without existing preference data', function () {
        this.sandbox.stub(KanPlanFeatureService, 'shouldShowKanbanBacklog').returns(true);
        this.isWorkMode = true;
        updateAcknowledgementData({});

        KanPlanAcknowledge.init();
        KanPlanAcknowledge.show();

        ok(KanPlanAcknowledge.hide.called, 'hide acknowledge should be called');
        equal(AJS.$('#gh .ghx-kanplan-ack').length, 1, 'acknowledge should be rendered');
    });

    test('acknowledge cannot be shown because data is not fetched yet', function () {
        KanPlanAcknowledge.show();

        equal(AJS.$('#gh .ghx-kanplan-ack').length, 0, 'acknowledge should NOT be rendered');
    });

    test('acknowledge cannot be shown because it shown last times', function () {
        updateAcknowledgementData({
            isClosedOnWorkMode: true,
            isClosedOnPlanMode: false
        });
        this.isWorkMode = true;

        KanPlanAcknowledge.init();
        KanPlanAcknowledge.show();

        equal(AJS.$('#gh .ghx-kanplan-ack').length, 0, 'acknowledge should NOT be rendered');
    });

    test('check can show acknowledge in work mode with KanPlan Lab enabled and KanPlan configured', function () {
        this.sandbox.stub(KanPlanFeatureService, 'shouldShowKanbanBacklog').returns(true);
        this.isWorkMode = true;
        updateAcknowledgementData({
            isClosedOnWorkMode: false,
            isClosedOnPlanMode: false
        });

        KanPlanAcknowledge.init();
        equal(KanPlanFeatureService.shouldShowAcknowledge(), true, 'acknowledge should be shown');
    });

    test('check can NOT show acknowledge in work mode with KanPlan Lab enabled and KanPlan configured', function () {
        this.sandbox.stub(KanPlanFeatureService, 'shouldShowKanbanBacklog').returns(true);
        this.isWorkMode = true;
        updateAcknowledgementData({
            isClosedOnWorkMode: true,
            isClosedOnPlanMode: false
        });

        KanPlanAcknowledge.init();
        equal(KanPlanFeatureService.shouldShowAcknowledge(), false, 'acknowledge should NOT be shown');
    });

    test('check can show acknowledge in plan mode with KanPlan Lab enabled and KanPlan configured', function () {
        this.sandbox.stub(KanPlanFeatureService, 'shouldShowKanbanBacklog').returns(true);
        this.isWorkMode = false;
        updateAcknowledgementData({
            isClosedOnWorkMode: false,
            isClosedOnPlanMode: false
        });

        KanPlanAcknowledge.init();
        equal(KanPlanFeatureService.shouldShowAcknowledge(), true, 'acknowledge should be shown');
    });

    test('check can NOT show acknowledge in plan mode with KanPlan Lab enabled and KanPlan configured', function () {
        this.sandbox.stub(KanPlanFeatureService, 'shouldShowKanbanBacklog').returns(true);
        this.isWorkMode = false;
        updateAcknowledgementData({
            isClosedOnWorkMode: false,
            isClosedOnPlanMode: true
        });

        KanPlanAcknowledge.init();
        equal(KanPlanFeatureService.shouldShowAcknowledge(), false, 'acknowledge should NOT be shown');
    });

    test('check can NOT show acknowledge in work mode with KanPlan Lab disabled', function () {
        GH.RapidBoard.kanPlanLabEnabled = false;
        GH.RapidViewConfig.kanPlanEnabled = true;
        this.isWorkMode = true;
        updateAcknowledgementData({
            isClosedOnWorkMode: false,
            isClosedOnPlanMode: false
        });

        KanPlanAcknowledge.init();
        equal(KanPlanFeatureService.shouldShowAcknowledge(), false, 'acknowledge should NOT be shown');
    });

    test('check can NOT show acknowledge in work mode with KanPlan not configured', function () {
        GH.RapidBoard.kanPlanLabEnabled = true;
        GH.RapidViewConfig.kanPlanEnabled = false;
        this.isWorkMode = true;
        updateAcknowledgementData({
            isClosedOnWorkMode: false,
            isClosedOnPlanMode: false
        });

        KanPlanAcknowledge.init();
        equal(KanPlanFeatureService.shouldShowAcknowledge(), false, 'acknowledge should NOT be shown');
    });

    test('acknowledge should hide', function () {
        AJS.$('#gh').append('<div class="ghx-kanplan-ack"></div>');

        KanPlanAcknowledge.init();
        this.hideStub.restore();
        KanPlanAcknowledge.hide();

        equal(AJS.$('#gh .ghx-kanplan-ack').length, 0, 'acknowledge should be rendered');
        ok(this.handleResizeEventStub.called, 'resize handler should be called');
    });

    test('acknowledge should be hidden after closing in workmode', function () {
        updateAcknowledgementData({});
        this.isWorkMode = true;
        GH.RapidBoard.State.data = {
            mode: 'work'
        };

        KanPlanAcknowledge.init();
        KanPlanAcknowledge.close();

        this.server.respond();

        ok(this.hideStub.called, 'hide should be called');
    });

    test('acknowledge should be hidden after closing in planmode', function () {
        updateAcknowledgementData({});
        this.isWorkMode = false;
        GH.RapidBoard.State.data = {
            mode: 'plan'
        };

        KanPlanAcknowledge.init();
        KanPlanAcknowledge.close();

        this.server.respond();

        ok(this.hideStub.called, 'hide should be called');
    });

    test('take me there should switch to kanplan backlog when it is enabled', function () {
        this.sandbox.stub(KanPlanFeatureService, 'shouldShowKanbanBacklog').returns(true);
        this.isWorkMode = true;

        GH.UserData.userConfig = {};
        GH.RapidBoard.State.data.mode = 'work';

        KanPlanAcknowledge.openBacklog();
        this.server.respond();

        ok(this.hideStub.called, 'hide should be called');
        ok(this.setModeStub.calledWith('plan'), 'should switch to plan mode');

        GH.UserData.userConfig = undefined;
    });

    test('take me there should NOT switch to kanplan backlog when it is disabled', function () {
        this.sandbox.stub(KanPlanFeatureService, 'shouldShowKanbanBacklog').returns(false);
        this.isWorkMode = true;

        KanPlanAcknowledge.openBacklog();

        this.server.respond();

        ok(this.hideStub.notCalled, 'hide should not be called');
        ok(this.setModeStub.notCalled, 'should not switch to plan mode');
    });

    test('acknowledge should not be displayed on board if dismissed in backlog', function () {
        this.sandbox.stub(KanPlanFeatureService, 'shouldShowKanbanBacklog').returns(true);
        this.isWorkMode = true;
        updateAcknowledgementData({
            isClosedOnWorkMode: false,
            isClosedOnPlanMode: true
        });

        KanPlanAcknowledge.init();
        equal(KanPlanFeatureService.shouldShowAcknowledge(), false, 'acknowledge should not be shown');
    });

    test('acknowledge should be displayed on backlog if dismissed on board', function () {
        this.sandbox.stub(KanPlanFeatureService, 'shouldShowKanbanBacklog').returns(true);
        this.isWorkMode = false;
        updateAcknowledgementData({
            isClosedOnWorkMode: true,
            isClosedOnPlanMode: false
        });

        KanPlanAcknowledge.init();
        equal(KanPlanFeatureService.shouldShowAcknowledge(), true, 'acknowledge should be shown');
    });
});