AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    module("loadContent", {
        setup: function() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function() {
            GH.Test.restoreServer(this);
            GH.Dialog.undim();
            GH.Notification.clear();
        }
    });

    test("Successful Ajax request renders the dialog", sinon.test(function() {
        this.stub(GH.Dialogs.RemoveStatus, "renderDialog");

        GH.Test.respondToGetWith200(this, "/workflow/status/remove.json", {});

        GH.Dialogs.RemoveStatus.showDialog();

        this.server.respond();

        ok(GH.Dialogs.RemoveStatus.renderDialog.called, "Called success method");
    }));

    test("Failed request does not call success method (no specific error handling)", sinon.test(function() {
        this.stub(GH.Dialogs.RemoveStatus, "renderDialog");
        this.stub(GH.Dialog, "undim");

        GH.Test.respondToGetWith500(this, "/workflow/status/remove.json", {});

        GH.Dialogs.RemoveStatus.showDialog();

        this.server.respond();

        ok(!GH.Dialogs.RemoveStatus.renderDialog.called, "Does not call process function on failure");
        ok(GH.Dialog.undim.called);
    }));

    test("submit: Successful AJAX call disposes the dialog", sinon.test(function() {

        GH.Test.respondToPostWith200(this, "/workflow/status/remove.json", {});

        var dialog = {};
        dialog.dispose = this.stub();
        dialog.enableControls = this.stub();

        GH.Dialogs.RemoveStatus.submit(dialog, { projectIssueDetails: [] });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(dialog.dispose.called, "Called success method");
        ok(!dialog.enableControls.called, "Did not call error method");

    }));

    test("submit: Failed AJAX call enables dialog controls)", sinon.test(function() {

        GH.Test.respondToPostWith500(this, "/workflow/status/remove.json", {});

        var dialog = {};
        dialog.enableControls = this.stub();
        dialog.dispose = this.stub();

        GH.Dialogs.RemoveStatus.submit(dialog, { projectIssueDetails: [] });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(dialog.enableControls.called, "Called failure method");
    }));
});