GH.AddIssuesToActiveSprintDialog = {};
GH.AddIssuesToActiveSprintDialog.Analytics = {};

(function() {
    var AnalyticsTracker = require('jira-agile/rapid/analytics-tracker');
    /**
     * @type module:jira-agile/rapid/analytics-tracker
     */
    GH.AddIssuesToActiveSprintDialog.Analytics.add = new AnalyticsTracker('gh.activesprint.issue.add');
})();

/**
 * Constructs a dialog for the given model
 */
GH.AddIssuesToActiveSprintDialog.showDialog = function(addToSprintModel, deferred) {

    var issueKeys = GH.IssueMoveController.getAllIssueKeys(addToSprintModel);

    // define the base dialog
    var dialog = GH.Dialog.create({
        width:600,
        height: 250,
        id:'ghx-add-issues-to-active-sprint',
        onCancelFn: function (dialog) {
            deferred.reject(issueKeys);
        }
    });

    dialog.addHeader(AJS.I18n.getText('gh.sprint.issue.move.dialog.title', issueKeys.length));
    dialog.addPanel('', 'panel');

    // render the dialog
    var html = GH.tpl.dialogs.addissuestoactivesprint.renderAddIssuesToActiveSprintDialog(addToSprintModel);

    dialog.getCurrentPanel().html(html);

    var buttonTitle = AJS.I18n.getText('gh.rapid.operations.confirm');
    dialog.addButton(
        buttonTitle,
        function () {
            dialog.disableControls();
            dialog.dispose();
            deferred.resolve(addToSprintModel);
        }, 'aui-button'
    );
    GH.Dialog.addCancelButton(dialog);

    dialog.show();
    dialog.updateHeight();
    // focus on the first button in the button bar
    AJS.$('#' + dialog.id).find('.dialog-button-panel .button-panel-cancel-link').focus();
};