AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid-tests",function(){require(["jira-agile/rapid/ui/detail/inlineedit/issue-editor-fake-server"],function(e){var s=require("jira/dialog/form-dialog"),t=require("jira/flag");module("Issue editor wrapper tests",{setup:function(){this.sandbox=sinon.sandbox.create(),this.context=AJS.test.mockableModuleContext(),this.JIRAFormDialog=this.sandbox.spy(s),this.sandbox.stub(this.JIRAFormDialog.prototype,"show"),this.context.mock("jira/dialog/form-dialog",this.JIRAFormDialog),this.sandbox.stub(t),this.context.mock("jira/flag",t),this.editor=this.context.require("jira-agile/rapid/ui/detail/inlineedit/issue-editor-wrapper"),e.setup(),this.editor.init({$detailContainer:AJS.$(),loadIssueDetailCallback:this.editor.loadIssueToEditor,getIssueIdCallback:function(){return e.issueId},getIssueKeyCallback:function(){return e.issueKey}}),this.sandbox.stub(this.editor.getWrappedIssueEditor(),"canDismissComment").returns(!0)},teardown:function(){e.teardown(),this.sandbox.restore(),this.editor.destroy()}}),test("When loading issues, should not call to server",function(){this.editor.loadIssueToEditor(),e.respond(),equal(e.getNumberOfServerCallsToLoadIssue(),0,"First time load an issue, must NOT hit the server"),this.editor.loadIssueToEditor(),e.respond(),equal(e.getNumberOfServerCallsToLoadIssue(),0,"Reload the same issue, must NOT hit the server"),e.issueId=2,e.issueKey="ISS-2",this.editor.loadIssueToEditor(),e.respond(),equal(e.getNumberOfServerCallsToLoadIssue(),0,"Issue was changed, must NOT hit the server"),this.editor.loadIssueToEditor(),e.respond(),equal(e.getNumberOfServerCallsToLoadIssue(),0,"Reload the same issue, must NOT hit the server"),this.editor.getWrappedIssueEditor().updateIssueWithQuery({attachmentOrder:"desc"}),e.respond(),equal(e.getNumberOfServerCallsToLoadIssue(),0,"View issue query has changed, must HIT the server")}),test("After saving a field, do not call to server to load issue data. Instead, directly use the save response",function(){this.editor.loadIssueToEditor(),e.respond(),this.editor.getWrappedIssueEditor().editIssueController.save(e.createSavingFieldModel()),e.respond(),equal(e.getNumberOfServerCallsToSaveIssue(),1,"Expect a POST to AjaxIssueAction"),equal(e.getNumberOfServerCallsToLoadIssue(),0,"After saved, directly use the save response, must NOT hit the server to load issue")}),test("When saving and the server returns HTML, it fails gracefully",function(){this.editor.loadIssueToEditor(),e.respond(),e.setResponse(e.responses["200_html"]),this.editor.getWrappedIssueEditor().editIssueController.save(e.createSavingFieldModel()),e.respond(),sinon.assert.calledOnce(this.JIRAFormDialog),equal(this.JIRAFormDialog.args[0][0].content.text(),"Probably not logged in","Expect correct Form Dialog content"),sinon.assert.calledOnce(this.JIRAFormDialog.prototype.show)}),test("When saving and the server returns a HTTP error, it fails gracefully",function(){this.editor.loadIssueToEditor(),e.respond(),e.setResponse(e.responses[500]),this.editor.getWrappedIssueEditor().editIssueController.save(e.createSavingFieldModel()),e.respond(),sinon.assert.calledOnce(t.showMsg),sinon.assert.calledWith(t.showMsg,"","<p>common.forms.ajax.error.dialog.heading</p><p>common.forms.ajax.error.dialog</p>",{type:"error"})}),module("getFieldsData test",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.editor=this.context.require("jira-agile/rapid/ui/detail/inlineedit/issue-editor-wrapper"),this.getInlineEditableFieldsCallback=sinon.stub().returns([]),this.editor.init({getInlineEditableFieldsCallback:this.getInlineEditableFieldsCallback}),sinon.stub(this.editor.getWrappedIssueEditor(),"canDismissComment").returns(!0),this.clock=sinon.useFakeTimers()},teardown:function(){this.editor.destroy(),this.clock.restore()}}),asyncTest("Should resolve the callback if the field data is defined",function(){var e=this.editor._getFieldsData();e.done(function(){start(),ok(!0,"Expected promise to be resolved.")}),this.clock.tick()}),asyncTest("Should not resolve callback if the field data is not defined",function(){this.getInlineEditableFieldsCallback.returns(null);var e=this.editor._getFieldsData();e.done(function(){start(),ok(!1,"Did not expect promise to resolve.")}),this.clock.tick(),start(),ok(!0)}),module("Issue editor wrapper method tests",{setup:function(){this.context=AJS.test.mockableModuleContext(),this.detailsModelStub=sinon.stub(GH.DetailsObjectFactory,"getDetailsModel").returns({isFieldInSection:function(e,s){return!1}}),this.editor=this.context.require("jira-agile/rapid/ui/detail/inlineedit/issue-editor-wrapper"),this.loadIssueDetailCallback=sinon.spy(),this.hasOtherEditsInProgress=sinon.stub(),this.editor.init({$detailContainer:AJS.$(),loadIssueDetailCallback:this.loadIssueDetailCallback,getInlineEditableFieldsCallback:function(){},getIssueIdCallback:function(){},getIssueKeyCallback:function(){},hasOtherEditsInProgress:this.hasOtherEditsInProgress});var e=this.editor.getWrappedIssueEditor();this.canDismissCommentStub=sinon.stub(e,"canDismissComment").returns(!0),this.getEditsInProgressStub=sinon.stub(e.editIssueController,"getEditsInProgress").returns([]),this.getDirtyEditsInProgressStub=sinon.stub(e.editIssueController,"getDirtyEditsInProgress").returns([])},teardown:function(){this.editor.destroy(),this.canDismissCommentStub.restore(),this.getEditsInProgressStub.restore(),this.getDirtyEditsInProgressStub.restore(),this.detailsModelStub.restore()}}),test("saveSuccess event handler calls the loadIssueDetailCallback with the correct fieldId",function(){this.editor.getWrappedIssueEditor().trigger("saveSuccess",{savedFieldIds:["magic-field"]});var e="magic-field";ok(this.loadIssueDetailCallback.calledOnce,"The callback was called");var s=this.loadIssueDetailCallback.lastCall.args[0];equal(s,e)}),test("hasEditsInProgress with no edits",function(){var e=this.editor.hasEditsInProgress();ok(!e,"Should not have edits in progress")}),test("hasEditsInProgress with some edits",function(){this.getEditsInProgressStub.returns(["some-field","some-other"]);var e=this.editor.hasEditsInProgress();ok(e,"Should have edits in progress")}),test("hasEditsInProgress with some dirty edits",function(){this.getDirtyEditsInProgressStub.returns(["some-field","some-other"]);var e=this.editor.hasEditsInProgress();ok(e,"Should have edits in progress")})})});