define('jira-agile/rapid/ui/detail/inlineedit/issue-editor-fake-server', function() {

    var numberOfServerCallsToLoadIssue = 0;
    var numberOfServerCallsToSaveIssue = 0;

    var FakeServer = {
        responses: {
            "200_json": function(request) {
                this._makeIssueResponse(request, 200);
            },
            "200_html": function(request) {
                this._makeHtmlErrorResponse(request, 200, "<!doctype html><html><body><div>Probably not logged in</div></body></html>");
            },
            "500": function (request) {
                this._makeHtmlErrorResponse(request, 500, "<!doctype html><html><body><div>500 Internal server error</div></body></html>");
            }
        },
        setup: function () {
            this.nextResponse = this.responses["200_json"];
            this.issueId = 1;
            this.issueKey = 'ISS-1';
            numberOfServerCallsToLoadIssue = 0;
            numberOfServerCallsToSaveIssue = 0;

            this.sandbox = sinon.sandbox.create({useFakeServer: true});
            this.server = this.sandbox.server;

            this.server.respondWith(new RegExp(AJS.contextPath() + "/secure/AjaxIssueAction!default\\.jspa.*"),
                function (request) {
                    numberOfServerCallsToLoadIssue++;
                    this.nextResponse(request);
                }.bind(this));

            this.server.respondWith("POST", new RegExp(AJS.contextPath() + "/secure/DetailsViewAjaxIssueAction\\.jspa.*"),
                function (request) {
                    numberOfServerCallsToSaveIssue++;
                    this.nextResponse(request);
                }.bind(this));
        },

        setResponse: function (response) {
            this.nextResponse = response;
        },

        _makeIssueResponse: function (request, code) {
            request.respond(code, {"Content-Type": "application/json"}, JSON.stringify(createFakeIssue(this.issueId, this.issueKey)));
        },

        _makeHtmlErrorResponse: function(request, code, htmlResponse) {
            request.respond(code, {"Content-Type": "text/html"}, htmlResponse);
        },

        teardown: function () {
            this.server.restore();
            this.sandbox.restore();
        },

        respond: function() {
            this.server.respond();
        },

        getNumberOfServerCallsToLoadIssue: function() {
            return numberOfServerCallsToLoadIssue;
        },

        getNumberOfServerCallsToSaveIssue: function() {
            return numberOfServerCallsToSaveIssue;
        },

        createSavingFieldModel: function () {
            // look at EditIssueController.js#save function to know how to build this fake object
            return {
                getId: function () {
                    return 'summary';
                },
                getSaving: function () {
                    return false;
                },
                getEditing: function () {
                    return true;
                },
                getInitParams: function () {
                    return {
                        summary: "xx"
                    };
                },
                getCurrentParams: function () {
                    return {
                        summary: "aa"
                    };
                },
                getFieldType: function() {
                    return null;
                }
            };
        }
    };

    function createFakeIssue (issueId, issueKey) {
        return {
            issue: {
                id: issueId,
                key: issueKey,
                summary: 'blabla',
                operations: {
                    linkGroups: []
                }
            },
            fields: {
                summary: 'blabla'
            },
            panels: {
                leftPanels: [],
                rightPanels: [],
                infoPanels: []
            },
            errorCollection: {
                errorMessages: [],
                errors: {}
            }
        };
    }

    return FakeServer;
});