define('jira-agile/rapid/ui/detail/inlineedit/inline-editable-details-model', [
    'require'
], function(
    require
) {
    'use strict';

    var _ = require('underscore');
    var DetailsModel = require('jira-agile/rapid/ui/detail/details-model');

    var InlineEditableDetailsModel = {};

    InlineEditableDetailsModel.getInlineEditableFields = function () {
        return this.viewData ? getTab(this.viewData, 'DETAILS').inlineEditableFields : null;
    };

    function getTab(viewData, tabId) {
        return _.find(viewData.tabs.defaultTabs, function(tab) { return tab.tabId.toLowerCase() === tabId.toLowerCase(); });
    }

    InlineEditableDetailsModel.getTimeTrackingFields = function () {
        var currentIssueRemainingEstimateField = this.getViewField('timeestimate');
        if (!currentIssueRemainingEstimateField) {
            return null;
        }

        // sum(parent's remaining estimate, subtasks' estimate)
        var aggregateRemainingField = this.getViewField('aggregatetimeestimate');
        // only subtasks' remaining estimate
        var aggregateRemainingSubtaskField = this.getViewField('aggregatetimeestimate_subtasks');

        return {
            currentIssueRemainingEstimateField: currentIssueRemainingEstimateField,
            aggregateRemainingField: aggregateRemainingField,
            aggregateRemainingSubtaskField: aggregateRemainingSubtaskField
        };
    };

    InlineEditableDetailsModel.getViewField = function(fieldId) {
        var headerTab = _.findWhere(this.viewData.tabs.defaultTabs, {tabId: 'HEADER'});
        return _.find(headerTab.fields, function(field) {
            return field.id === fieldId;
        });
    };

    /**
     * Process the fields that were returned in the view data and assign them to their correct field sections
     * @param viewData
     */
    InlineEditableDetailsModel.processFields = function (viewData) {
        // initialise sections
        this.fieldSections = {
            header: [],
            estimate: [],
            details: [],
            people: [],
            dates: [],
            links: [],
            description: []
        };

        // get the configured estimate statistic and tracking statistic IDs
        var estimateStatisticFieldId = viewData.primaryStatisticFieldId || "";
        var trackingStatisticFieldId = viewData.trackingStatisticFieldId || "";

        var headerTab = _.findWhere(viewData.tabs.defaultTabs, {tabId: 'HEADER'});
        _.forEach(headerTab.fields, function (field) {
            if (!field || !field.id) {
                return;
            }
            if (field.id === estimateStatisticFieldId) {
                this.fieldSections.estimate.push(field.id);
            } else if (field.id !== trackingStatisticFieldId &&
                field.id !== 'aggregatetimeestimate' &&
                field.id !== 'aggregatetimeestimate_subtasks') {
                var section = this.FIELD_SECTION_PRESETS[field.id];
                section = section || field.category || 'details';
                if (section !== 'unsupported') {
                    this.fieldSections[section].push(field.id);
                }
            }
        }.bind(this));
    };

    return _.extend(DetailsModel, InlineEditableDetailsModel);
});
