AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    var ExtraFieldsHelper = require('jira-agile/rapid/ui/component/extra-fields/ExtraFieldsHelper');

    test("prepareExtraFields: return html or text from extra fields's selected values when default renderer", sinon.test(function () {

        var multiSelectHtmlContent = "<div class='shorten' id='customfield_10001-field'><span>option 1, </span><span>option 2</span></div>";
        var extraFields = [{
            text: "option 1",
            id: "customfield_10000",
            label: "single select"
        }, {
            html: multiSelectHtmlContent,
            id: "customfield_10001",
            label: "multi select"
        }];

        ExtraFieldsHelper.prepareExtraFields(extraFields);

        equal(extraFields[0].renderedContent, 'option 1');
        equal(extraFields[0].useSoyNoAutoescape, undefined);
        equal(extraFields[1].renderedContent, multiSelectHtmlContent);
        equal(extraFields[1].useSoyNoAutoescape, undefined);
    }));

    test("prepareExtraFields: return html from extra fields's and mark as to not be autoescaped by soy when html renderer selected", sinon.test(function () {
        var multiSelectHtmlContent = "<div class='shorten' id='customfield_10001-field'><span>option 1, </span><span>option 2</span></div>";
        var extraFields = [{
            html: "option 1",
            id: "customfield_10000",
            label: "single select",
            renderer: "html"
        }, {
            html: multiSelectHtmlContent,
            id: "customfield_10001",
            label: "multi select",
            renderer: "html"
        }];

        ExtraFieldsHelper.prepareExtraFields(extraFields);

        equal(extraFields[0].renderedContent, 'option 1');
        equal(extraFields[0].useSoyNoAutoescape, true);
        equal(extraFields[1].renderedContent, multiSelectHtmlContent);
        equal(extraFields[1].useSoyNoAutoescape, true);
    }));
});