AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    var actionsPlanCssClass = "js-view-actions-plan";
    var actionsWorkCssClass = "js-view-actions-work";
    var printCardsActionCssClass = "js-view-action-print-cards";

    var actionsPlanSelector = "." + actionsPlanCssClass;
    var actionsWorkSelector = "." + actionsWorkSelector;
    var printCardsActionSelector = "." + printCardsActionCssClass;

    module("setMode", {
        setup: function() {
            GH.ViewActions.refreshBoardTools = sinon.spy();
            GH.tpl.board.x.renderToolSections = sinon.spy();
        },

        teardown: function() {
            GH.RapidViewConfig.currentData.data = null;
        }
    });

    test("sets the mode to the passed mode", function() {
        GH.ViewActions.mode = null;
        GH.ViewActions.setMode(GH.ViewActions.PLAN_MODE);
        equal(GH.ViewActions.mode, GH.ViewActions.PLAN_MODE);
    });

    test("setting the mode refreshes board tools", function() {
        GH.ViewActions.mode = null;
        GH.ViewActions.setMode(GH.ViewActions.PLAN_MODE);
        GH.ViewActions.setMode(GH.ViewActions.WORK_MODE);
        GH.ViewActions.setMode(GH.ViewActions.REPORT_MODE);

        equal(GH.ViewActions.refreshBoardTools.callCount, 3);
    });

    test("Plan Mode shows the plan actions, hides the work actions, removes aui-last class from parent and disabled class from list", function() {

        var htmlString = "" +
            "<div class='aui-last' id='parent'>" +
                "<div class='" + actionsPlanCssClass + "'>" +
                    "<ul><li id='child-li' class='disabled'></li></ul>" +
                "</div>" +
            "</div>";

        QUnit.GhFixtures.addFixture(htmlString);
        QUnit.GhFixtures.addFixture("<div class='" + actionsWorkCssClass + "' />");

        GH.ViewActions.setMode(GH.ViewActions.PLAN_MODE);

        ok(AJS.$(actionsPlanSelector).is(":visible"));
        ok(!AJS.$(actionsWorkSelector).is(":visible"));
        ok(!AJS.$("parent").hasClass("aui-last"));
        ok(!AJS.$("child-li").hasClass("disabled"));
    });

    test("Plan Mode shows Print cards action", function() {
        GH.RapidViewConfig.currentData.data = {sprintSupportEnabled : true};
        executeTestPrintCardsActionInMode(GH.ViewActions.PLAN_MODE, true);
    });
    test("Kanban plan mode show Print cards action", function() {
        GH.RapidViewConfig.currentData.data = {sprintSupportEnabled : false};
        executeTestPrintCardsActionInMode(GH.ViewActions.PLAN_MODE, true);
    });
    test("Work Mode shows Print cards action", function() {
        executeTestPrintCardsActionInMode(GH.ViewActions.WORK_MODE, true);
    });
    test("Report Mode does not show Print cards action", function() {
        executeTestPrintCardsActionInMode(GH.ViewActions.REPORT_MODE, false);
    });

    function executeTestPrintCardsActionInMode(mode, shown) {
        var htmlString = [
            '<div class="aui-list" id="board-tools-section-content">',
                '<ul id="view-actions-print" class="aui-list-section js-view-actions-print">',
                    '<li class="aui-list-item">',
                        '<a class="aui-list-item-link ', printCardsActionCssClass, ' disabled">Print cards</a>',
                    '</li>',
                '</ul>',
            '</div>',
        ].join('');

        QUnit.GhFixtures.addFixture(htmlString);

        GH.ViewActions.adjustButtonsToMode(mode);

        ok(shown === !AJS.$(printCardsActionSelector).parent().is(':hidden'));
        ok(shown === !AJS.$(printCardsActionSelector).hasClass('disabled'));
    }

    test("toggleEpicsShowOnRapidBoard: Toggle epics on", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "getEpicShownOnRapidBoard").returns(true);
        this.stub(GH.RapidBoard.State, "setEpicShownOnRapidBoard");
        this.stub(GH.ViewActions, "setEpicLozengesVisible");

        GH.ViewActions.toggleEpicsShowOnRapidBoard();

        ok(GH.RapidBoard.State.setEpicShownOnRapidBoard.calledWith(false), "should set the state");
        ok(GH.ViewActions.setEpicLozengesVisible.calledWith(false), "should call to update menu item");
    }));

    test("toggleEpicsShowOnWorkboard: Toggle epics off", sinon.test(function () {
        this.stub(GH.RapidBoard.State, "getEpicShownOnRapidBoard").returns(false);
        this.stub(GH.RapidBoard.State, "setEpicShownOnRapidBoard");
        this.stub(GH.ViewActions, "setEpicLozengesVisible");

        GH.ViewActions.toggleEpicsShowOnRapidBoard();

        ok(GH.RapidBoard.State.setEpicShownOnRapidBoard.calledWith(true), "should set the state");
        ok(GH.ViewActions.setEpicLozengesVisible.calledWith(true), "should call to update menu item");
    }));
});
