AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-config"], function() {
    var EstimatePicker = require('jira-agile/rapid/ui/component/estimate-picker');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.trigger('pre-initialization');

    module("Ajax tests", {
        setup: function() {
            GH.Test.setUpFakeServer(this);

            this.response = {
                currentEstimationStatistic : {id: "currEstimate", isEnabled : true},
                currentTrackingStatistic : {id: "currTracking", isEnabled : true},
                availableEstimationStatistics: [{id: "estimate1", isEnabled : true}, this.currentEstimationStatistic, {id: "estimate3", isEnabled : true}]
            };
        },
        teardown: function() {
            GH.Test.restoreServer(this);
        }
    });

    test('module "jira-agile/rapid/ui/component/estimate-picker" exists', function() {
        ok(EstimatePicker);
        ok(GH.EstimatePicker);
    });

    test("estimatePicker: load function correctly sets tracking field as default", sinon.test(function() {
        var picker = new EstimatePicker("testPicker", true);

        this.stub(GH.ChartView, "getChartControls");
        this.stub(GH.ChartView, "showChartControls");
        this.stub(picker, "render");

        GH.Test.respondToGetWith200(this, "/rapidviewconfig/estimation.json", this.response);

        picker.load(1, function(){});

        this.server.respond();

        ok(picker.getDefaultItem().id === "currTracking", "Time tracking option set as default.");

        ok(picker.render.called, "Called render method");

    }));

    test("estimatePicker: load function correctly sets correct estimate field as default", sinon.test(function() {
        var picker = new EstimatePicker("testPicker", true);

        this.stub(GH.ChartView, "getChartControls");
        this.stub(GH.ChartView, "showChartControls");
        this.stub(picker, "render");

        // Disable the time tracking field.
        this.response.currentTrackingStatistic.isEnabled = false;

        GH.Test.respondToGetWith200(this, "/rapidviewconfig/estimation.json", this.response);

        picker.load(1, function(){});

        this.server.respond();

        ok(picker.getDefaultItem().id === "currEstimate", "Correct estimate option set as default.");

        ok(picker.render.called, "Called render method");

    }));
});
