/* global c3, GH */

(function (multipleCharts, c3) {
    'use strict';

    function BurnupChartLegend() {

        function renderLegendBar(selection, barClass, seriesClass) {
            return selection.append('g').classed(barClass, true).append('line').attr('stroke-linecap', 'round').attr('x1', '0').attr('y1', '20').attr('x2', '20').attr('y2', '20').attr('transform', 'translate(-10,3), rotate(-45)').classed(seriesClass, true);
        }

        var completed = function completed(selection) {
            renderLegendBar(selection, 'ghx-burnup-line-legend', 'completed-work');
        };

        var guideline = function guideline(selection) {
            renderLegendBar(selection, 'ghx-burnup-line-legend', 'guideline');
        };

        var scope = function scope(selection) {
            renderLegendBar(selection, 'ghx-burnup-line-legend', 'scope');
        };

        var scopeProjection = function scopeProjection(selection) {
            renderLegendBar(selection, 'ghx-burnup-line-legend', 'scope-projection');
        };

        return c3.component('sprintBurnupChartLegend').extend(multipleCharts()).charts([scope, scopeProjection, completed, guideline]);
    }

    GH.Reports.BurnupChartLegend = BurnupChartLegend;
})(GH.Reports.multipleCharts, c3);