define('jira-agile/rapid/ui/chart/v2/burnup/burnup-chart-data-service', ['require'], function (require) {
    'use strict';

    // REQUIRES

    var _ = require('underscore');
    var GlobalEvents = require('jira-agile/rapid/global-events');

    var Ajax;
    var RapidViewConfig;
    var SprintBurnupTransformer;

    GlobalEvents.on('pre-initialization', function () {
        Ajax = GH.Ajax;
        RapidViewConfig = GH.RapidViewConfig;
        SprintBurnupTransformer = GH.Reports.SprintBurnupTransformer;
    });

    /**
     * Sends request to retrieve data
     *
     * @param {Object} requestParams
     * @returns {Promise}
     */
    function fetchData(requestParams) {
        // the burndown chart endpoint has everything we need
        var opts = {
            url: '/rapid/charts/scopechangeburndownchart',
            data: requestParams
        };

        return Ajax.get(opts, 'sprintburnupchart');
    }

    /**
     * Transform data to a form that the chart can render.
     *
     * @param {Object} data
     * @returns {Object} transformed
     */
    function transformData(data) {
        return SprintBurnupTransformer.getBurnupModelFromScopeBurndownModel(data);
    }

    function SprintBurnupChartDataService() {}

    SprintBurnupChartDataService.prototype = {
        /**
         *
         * @param {number} rapidViewId
         * @param {number} sprintId
         * @param {number} estimateStatisticId
         * @returns {Promise}
         */
        get: function get(rapidViewId, sprintId, estimateStatisticId) {
            return this._getData(rapidViewId, sprintId, estimateStatisticId).andThen(function (data) {
                data.rapidViewId = RapidViewConfig.currentData.id;
                return transformData(data);
            });
        },

        /**
         * Clear cached data
         */
        clearCache: function clearCache() {
            if (this._dataPromise) {
                this._dataPromise = null;
                this._dataRequestParams = null;
            }
        },

        /**
         * For testing
         *
         * @private
         */
        _transformData: transformData,

        /**
         * Gets raw data for given rapidViewId, sprintId and filterOptions. Data could be retrieved from cache if available.
         *
         * @param {number} rapidViewId
         * @param {number} sprintId
         * @param {number} estimateStatisticId
         * @param {object} [filterOptions]
         * @returns {Promise}
         * @private
         */
        _getData: function _getData(rapidViewId, sprintId, estimateStatisticId) {
            var requestParams = {
                rapidViewId: rapidViewId,
                sprintId: sprintId,
                statisticFieldId: estimateStatisticId
            };
            // Only send a request if previous one cannot be used
            if (!this._dataPromise || this._dataPromise.state() === 'rejected' || !_.isEqual(this._dataRequestParams, requestParams)) {
                this._dataRequestParams = requestParams;
                this._dataPromise = fetchData(requestParams);
            }
            return this._dataPromise;
        }
    };

    return SprintBurnupChartDataService;
});