AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid'], function () {
    var _ = require('underscore');
    var ReleaseDatePredictor = require('jira-agile/rapid/ui/chart/release-date-predictor');
    var VersionReport = require('jira-agile/rapid/ui/chart/version-report');
    var VersionReportModel = require('jira-agile/rapid/ui/chart/version-report-model');

    module('model');

    test('module "jira-agile/rapid/ui/chart/version-report-model" exists', function () {
        ok(VersionReportModel);
        ok(GH.VersionReportModel);
    });

    test('module "jira-agile/rapid/ui/chart/version-report" exists', function () {
        ok(VersionReport);
        ok(GH.VersionReport);
    });

    test('Version model is correctly built', function () {
        var estimationStatistic = {
            name: 'Story Points',
            typeId: 'field'
        };

        VersionReport.createModel(estimationStatistic);
        var model = VersionReport.model;
        model.setRawData(GH.AjaxTest.Data.UnreleasedVersionReport);

        // check we set the contents - used in the view
        var content = model.getReportContent();
        equal(content, GH.AjaxTest.Data.UnreleasedVersionReport.contents);

        // check all the issues have an estimate
        var issuesWithNoEstimateText = _.find(content.completedIssues, function (issue) {
            return _.isUndefined(issue.estimateStatistic.statFieldValue.text);
        });
        ok(_.isEmpty(issuesWithNoEstimateText));
        issuesWithNoEstimateText = _.find(content.incompleteUnestimatedIssues, function (issue) {
            return _.isUndefined(issue.estimateStatistic.statFieldValue.text);
        });
        ok(_.isEmpty(issuesWithNoEstimateText));
        issuesWithNoEstimateText = _.find(content.incompleteEstimatedIssues, function (issue) {
            return _.isUndefined(issue.estimateStatistic.statFieldValue.text);
        });
        ok(_.isEmpty(issuesWithNoEstimateText));

        // check that we removed the decimal (Story Point estimates)
        equal(content.completedIssuesEstimateSum.text.indexOf('.'), -1);
        equal(content.incompletedIssuesEstimateSum.text.indexOf('.'), -1);

        // check we built jql - other tests check content
        var jql = model.getJql();
        ok(jql.completedIssues);
        ok(jql.allIssues);
        ok(jql.incompleteEstimatedIssues);
        ok(jql.incompleteUnestimatedIssues);
    });

    module('hasIssues', {
        setup: function setup() {
            this.estimationStatistic = {
                typeId: 'field',
                fieldId: 'customfield_10020',
                name: 'Story Points'
            };
        }
    });

    test('Has content but no issues', sinon.test(function () {
        VersionReport.createModel(this.estimationStatistic);
        var model = VersionReport.model;
        model.setRawData(GH.AjaxTest.Data.EmptyVersionReport);
        ok(!model.hasIssues());
    }));

    test('Has content and issues', sinon.test(function () {
        VersionReport.createModel(this.estimationStatistic);
        var model = VersionReport.model;
        model.setRawData(GH.AjaxTest.Data.ReleasedVersionReport);
        ok(model.hasIssues());
    }));

    test('Has no content but issues in changes', sinon.test(function () {
        VersionReport.createModel(this.estimationStatistic);
        var model = VersionReport.model;
        model.setRawChartData(GH.AjaxTest.Data.ReleasedVersionProgressChart);
        ok(model.hasIssues());
    }));

    test('Has no content and no issues in changes', sinon.test(function () {
        VersionReport.createModel(this.estimationStatistic);
        var model = VersionReport.model;
        model.setRawChartData(GH.AjaxTest.Data.EmptyVersionProgressChart);
        ok(!model.hasIssues());
    }));

    module('series calculation', {
        setup: function setup() {
            this.estimationStatistic = {
                typeId: 'field',
                fieldId: 'customfield_10002'
            };
        }
    });

    test('series correctly generated for issue count', function () {
        VersionReport.createModel({
            typeId: 'issueCount'
        });
        var model = VersionReport.model;
        model.setRawChartData(GH.AjaxTest.Data.ReleasedVersionProgressChart);

        var allSeries = model.getSeries();
        equal(allSeries.length, 3);

        var issueCountSeries = allSeries[0];
        var completedSeries = allSeries[1];

        equal(issueCountSeries.id, 'totalEstimate');
        equal(completedSeries.yaxis, 1);
        equal(completedSeries.id, 'completedEstimate');
        equal(completedSeries.yaxis, 1);
    });

    test('series correctly generated for other estimation statistic', function () {
        VersionReport.createModel(this.estimationStatistic);
        var model = VersionReport.model;
        model.setRawChartData(GH.AjaxTest.Data.ReleasedVersionProgressChart);

        var allSeries = model.getSeries();
        equal(allSeries.length, 5);

        var issueCountSeries = allSeries[2];
        var unestimatedSeries = allSeries[3];
        var totalSeries = allSeries[0];
        var completedSeries = allSeries[1];

        equal(issueCountSeries.id, 'issueCount');
        equal(issueCountSeries.yaxis, 2);
        equal(unestimatedSeries.id, 'unestimatedIssueCount');
        equal(unestimatedSeries.yaxis, 2);
        equal(totalSeries.id, 'totalEstimate');
        equal(totalSeries.yaxis, 1);
        equal(completedSeries.id, 'completedEstimate');
        equal(completedSeries.yaxis, 1);
    });

    test('released version has no predictions', sinon.test(function () {
        VersionReport.createModel(this.estimationStatistic);
        var model = VersionReport.model;
        model.setRawChartData(GH.AjaxTest.Data.ReleasedVersionProgressChart);

        var series = model.getVersionSeries();
        ok(!_.findWhere(this.series, { id: 'prediction' }), 'No prediction series');
    }));

    test('uses 5 times of pessimistic guess to get furthest date', sinon.test(function () {

        this.stub(ReleaseDatePredictor, 'getPredictedCompletedEstimatePerDay').returns({
            pessimistic: 5
        });
        var now = new Date().valueOf();
        VersionReport.createModel(this.estimationStatistic);
        var model = VersionReport.model;

        // fake the series - remaining scope will be 8
        model.series = [{
            id: 'totalEstimate',
            data: [[1, 10]]
        }, {
            id: 'completedEstimate',
            data: [[1, 2]]
        }];
        model.chartData = {
            now: now
        };
        model.seriesData = [];

        var furthestDate = model.getFurthestDateForNonWorkingDaysData();
        equal(furthestDate, now + GH.ChartUtils.oneDayInMillis * 8);
    }));

    test('uses 5 times of standard guess if pessimistic points per day is 0 to get furthest date', sinon.test(function () {
        this.stub(ReleaseDatePredictor, 'getPredictedCompletedEstimatePerDay').returns({
            pessimistic: 0,
            standard: 10
        });
        var now = new Date().valueOf();
        VersionReport.createModel(this.estimationStatistic);
        var model = VersionReport.model;

        // fake the series - remaining scope will be 8
        model.series = [{
            id: 'totalEstimate',
            data: [[1, 10]]
        }, {
            id: 'completedEstimate',
            data: [[1, 2]]
        }];
        model.chartData = {
            now: now
        };
        model.seriesData = [];

        var furthestDate = model.getFurthestDateForNonWorkingDaysData();
        equal(furthestDate, now + GH.ChartUtils.oneDayInMillis * 4);
    }));
});