AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid", "jira.webresources:calendar-localisation-moment"], function() {
    module("isValidDate")

    test("correctly validates a date", function() {
        ok(GH.ChartTimeFrames.isValidDate('01.02.2016'));
    });

    test("correctly recognizes an invalid date", function() {
        ok(!GH.ChartTimeFrames.isValidDate('01/02/2016'));
        ok(!GH.ChartTimeFrames.isValidDate(''));
        ok(!GH.ChartTimeFrames.isValidDate('01/Blahblah/2016'));
    });

    module("Handling dialog save");

    test("handles correct input correctly", function () {
        GH.ChartTimeFrames.setNewChartLimits = function(activeDays, from, to) {
            equal(activeDays, -5);

            var fromDate = new Date(from),
                toDate = new Date(to);

            equal(fromDate.getDate(), 12);
            equal(fromDate.getMonth(), 0);
            equal(fromDate.getFullYear(), 2016);

            equal(toDate.getDate(), 18);
            equal(toDate.getMonth(), 0);
            equal(toDate.getFullYear(), 2016);
        };

        var fromDateChooser = { val: function() { return "12.1.2016"; } };
        var toDateChooser   = { val: function() { return "18.1.2016"; } };

        var button = {
            attr: function() {
                return -5;
            }
        };

        var contents = {
            find: function(selector) {
                if (selector === '.js-timeframe-button.active') {
                    return button;
                } else if (selector === '#ghx-field-from') {
                    return fromDateChooser;
                } else if (selector === '#ghx-field-to') {
                    return toDateChooser;
                } else {
                    return this;
                }
            },
            closest: function() {
                return this;
            },
            append: function() {

            },
            remove: function() {

            }
        };

        GH.ChartTimeFrames.handleDialogSave(contents);
    });

    test("handles incorrect input correctly", function () {
        expect(0);

        GH.ChartTimeFrames.setNewChartLimits = function() {
            notOk(true);
        };

        var fromDateChooser = { val:     function() { return "12/Jan/2016"; },
                                closest: function() { return this; },
                                append:  function() { } };
        var toDateChooser   = { val:     function() { return "18$Jan$2016"; },
                                closest: function() { return this; },
                                append:  function() { } };


        var button = {
            attr: function() {
                return -5;
            }
        };

        var contents = {
            find: function(selector) {
                if (selector === '.js-timeframe-button.active') {
                    return button;
                } else if (selector === '#ghx-field-from') {
                    return fromDateChooser;
                } else if (selector === '#ghx-field-to') {
                    return toDateChooser;
                } else {

                    return { remove: function() { } };
                }
            }
        };

        GH.ChartTimeFrames.handleDialogSave(contents);
    });
});