AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid'], function() {
    var BurndownRate = require('jira-agile/rapid/ui/chart/burndown-rate');

    var startDate = new Date(2012, 10, 26).valueOf(); // Monday
    var endDate = new Date(2012, 11, 7).valueOf(); // Friday, 11 days later
    var startWeekend = new Date(2012, 11, 1).valueOf();
    var endWeekend = new Date(2012, 11, 3).valueOf();

    var workRates = {
        timezone: 'Australia/Sydney',
        rates: [
            { start: startDate, end: startWeekend, rate: 1 },
            { start: startWeekend, end: endWeekend, rate: 0 },
            { start: endWeekend, end: endDate, rate: 1 }
        ]
    };

    test('module "jira-agile/rapid/ui/chart/burndown-rate" exists', function() {
        ok(BurndownRate);
        ok(GH.BurndownRate);
    });

    test('Knows whether a date is inside a non-working rate or not', function() {

        var workingDate = new Date(2012, 10, 28).valueOf();
        var nonWorkingDate = new Date(2012, 11, 2).valueOf();

        BurndownRate.setRateData(workRates);

        equal(BurndownRate.isDateInNonWorkingBlock(workingDate), false);
        equal(BurndownRate.isDateInNonWorkingBlock(nonWorkingDate), true);
        equal(BurndownRate.isDateInNonWorkingBlock(startDate), false);
        equal(BurndownRate.isDateInNonWorkingBlock(startWeekend), true);
        equal(BurndownRate.isDateInNonWorkingBlock(endWeekend), false);

    });
});
