/* global GH */
AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid'], function() {
    var BurndownChartController = require('jira-agile/rapid/ui/chart/burndown-chart-controller');
    var BurndownReportChartController = require('jira-agile/rapid/ui/chart/burndown-report-chart-controller');
    var ChartView = require('jira-agile/rapid/ui/chart/chart-view');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.trigger('pre-initialization');

    // GLOBALS
    var Test = GH.Test;

    module('BurndownChartController tests', {
        setup: function() {
            Test.setUpFakeServer(this);
            BurndownChartController.sprintPicker = {
                getSelectedItem: function() { return {id: 1}; }
            };
            BurndownChartController.estimatePicker = {
                getSelectedItem: function() { return {id: 1}; },
                load: function() {}
            };
        },
        teardown: function() {
            Test.restoreServer(this);
        }
    });

    test('module "jira-agile/rapid/ui/chart/burndown-chart-controller" exists', function() {
        ok(BurndownChartController);
        ok(GH.BurndownChartController);
    });

    test('loadSprintOptions: successful Ajax request passes to process sprint data', sinon.test(function() {
        this.stub(BurndownChartController, 'processSprintsData');

        Test.respondToGetWith200(this, '/sprintquery/', {});

        BurndownChartController.loadChart();

        this.server.respond();

        ok(BurndownChartController.processSprintsData.called, 'Called success method');
    }));

    test('loadSprintOptions: failed Ajax request does not try to process data (no error handling)', sinon.test(function() {
        this.stub(BurndownChartController, 'processSprintsData');

        Test.respondToGetWith500(this, '/sprintquery/', {});

        BurndownChartController.loadChart();

        this.server.respond();

        ok(!BurndownChartController.processSprintsData.called, 'Does not call process function on failure');
    }));

    test('loadChartData: successful Ajax request passes to process chart data', sinon.test(function() {
        this.stub(BurndownReportChartController, 'processChartData');

        Test.respondToGetWith200(this, '/rapid/charts/scopechangeburndownchart.json', {});

        BurndownReportChartController.setSprintId(1);
        BurndownReportChartController.loadChartData();

        this.server.respond();

        ok(BurndownReportChartController.processChartData.called, 'Called success method');
    }));

    test('loadChartData: failed Ajax request hides the spinner', sinon.test(function() {
        this.stub(BurndownReportChartController, 'processChartData');
        this.stub(ChartView, 'hideSpinner');

        Test.respondToGetWith500(this, '/rapid/charts/scopechangeburndownchart.json', {});

        BurndownReportChartController.setSprintId(1);
        BurndownReportChartController.loadChartData();

        this.server.respond();

        ok(!BurndownReportChartController.processChartData.called, 'Does not call process function on failure');
        ok(ChartView.hideSpinner.called, 'hides spinner on failure');
    }));

    test('estimatePicker: estimatePicker change reloads the chart', sinon.test(function() {
        this.stub(BurndownReportChartController, 'loadChartData');

        BurndownChartController.displayed = true;
        BurndownChartController.handleEstimateChanged();
        ok(BurndownReportChartController.loadChartData.called, 'chart loaded on estimate picker change');
    }));
});
