GH.RapidBoard.QuickEdit = {};

// changelog for fields in the edit dialog
GH.RapidBoard.QuickEdit.fieldChanges = {};

/**
 * Initializes QuickEdit
 */
GH.RapidBoard.QuickEdit.init = function () {
    // get rid of all other handlers (view issue page adds a page reload handler)
    // register our own sessionComplete handler
    AJS.$(AJS).unbind("QuickEdit.sessionComplete");
    AJS.$(AJS).bind("QuickEdit.sessionComplete", function () {
        // show the updated message
        if (JIRA && JIRA.IssueNavigator && JIRA.IssueNavigator.setIssueUpdatedMsg) {
            JIRA.IssueNavigator.setIssueUpdatedMsg();
        }
        GH.Notification.showIssueMessage();
        AJS.$(GH).trigger('issueUpdated', {
            issueId: GH.IssueOperationShortcuts.getSelectedIssueId(),
            source: "quickEdit",
            fieldChanges: GH.RapidBoard.QuickEdit.fieldChanges
        });

        // reset field changelog
        GH.RapidBoard.QuickEdit.fieldChanges = {};

        // clear possible overwrites
        GH.IssueOperationShortcuts.clearOverrideSelectedIssue();
    });
    // make sure we clear out the selected issue overwrite on dialog cancel/escape as well
    JIRA.bind("Dialog.hide", function (e, $dialog, reason) {
        if ($dialog.attr("id") === "edit-issue-dialog" && (reason === JIRA.Dialog.HIDE_REASON.cancel || reason === JIRA.Dialog.HIDE_REASON.escape)) {
            GH.IssueOperationShortcuts.clearOverrideSelectedIssue();
            // reset field changelog
            GH.RapidBoard.QuickEdit.fieldChanges = {};
        }
    });

    AJS.$(GH).bind("QuickEdit.fieldChange", function (event, data) {
        GH.RapidBoard.QuickEdit.fieldChanges[data.fieldId] = data.fieldChangeData;
    });

    // ensure the issue key is displayed in QuickEdit
    if (JIRA && JIRA.Dialog && JIRA.Dialog.shouldShowIssueKeyInTitle) {
        // overwrite to display the key on the rapid board
        JIRA.Dialog.shouldShowIssueKeyInTitle = function () {
            return true;
        };
    }
};