/**
 * All animation functions in JIRA Agile must be placed here. In this way we accomplishe the following things:
 *  - Gives easy and convenient way of doing animation
 *  - Abstracts the exact mechanics of doing the animations (like libraries and such)
 */
GH.RapidBoard.Animation = (function(jq) {
    var DEFAULT_DURATION = 200;
    var LONG_DURATION = 500;
    var ANIMATION_CLASS = 'js-animation-inprogress';

    function animateWithJQuery($element, props, duration) {
        return $element.addClass(ANIMATION_CLASS).animate(props, duration || DEFAULT_DURATION).promise().done(function() {
            $element.removeClass(ANIMATION_CLASS);
        });
    }

    /**
     * Animates transition from height to height.
     */
    function animateHeight(selector, startHeight, endHeight, duration) {
        var element = jq(selector);
        element.css({height: startHeight});
        return animateWithJQuery(element, {height: endHeight}, duration).done(function() {
            element.css({height: ""});
        });
    }

    function animateHeightToAuto(selector, duration) {
        var $element = jq(selector);
        var currentHeight = $element.height();
        $element.css('height', 'auto');
        var targetHeight = $element.height();
        $element.css('height', currentHeight);
        return animateWithJQuery($element, { height: targetHeight }, duration).done(function() {
            $element.css('height', 'auto');
        });
    }

    function animateHeightToZero(selector, duration) {
        var $element = jq(selector);
        return animateWithJQuery($element, { height: 0 }, duration);
    }

    /**
     * Bring Attention to Changes in UI
     */
    function fadeElement(element, BgCol, elBorderCol) {
        var el = jq(element);

        // passed in values
        var elBgCol = BgCol || '#fff';
        var elBorderCol = elBorderCol || '#d6d6d6';

        // the fade values - from style guide
        var fadeBgCol = "#ebf2f9";// pale blue
        var fadeBorderCol = "#ccd9ea";// pale blue

        el.addClass(ANIMATION_CLASS);
        el.stop() //stop any previous animation
            // animate to highlight/fade values
            .animate({
                "background-color":fadeBgCol,
                "border-top-color":fadeBorderCol,
                "border-left-color":fadeBorderCol,
                "border-right-color":fadeBorderCol,
                "border-bottom-color":fadeBorderCol
            }, 250)
            // wait a bit
            .delay(1200)
            // revert all the things
            .animate({
                "background-color":elBgCol,
                "border-top-color":elBorderCol,
                "border-left-color":elBorderCol,
                "border-right-color":elBorderCol,
                "border-bottom-color":elBorderCol
            }, 500)
            .promise().done(function() {
                el.css({
                    "background-color":"",
                    "border-top-color":"",
                    "border-left-color":"",
                    "border-right-color":"",
                    "border-bottom-color":""
                });
                el.removeClass(ANIMATION_CLASS);
            });
    }

    return {
        DEFAULT_DURATION: DEFAULT_DURATION,
        LONG_DURATION: LONG_DURATION,
        animateHeight: animateHeight,
        animateHeightToAuto: animateHeightToAuto,
        animateHeightToZero: animateHeightToZero,
        fadeElement: fadeElement
    };
})(AJS.$);

