/**
 * Defines functions called by the keyboard-shortcut modules.
 * This file defines implementations for keyboard shortcuts when on the Rapid Board.
 * For each function that is defined here, you must also define one in gh-keyboardshortcuts.js.
 */
GH.Shortcut = {
    // "globally applicable links"
    focusBoardSearch: function focusBoardSearch() {},
    newIssue: function newIssue() {
        AJS.$('#create_link').click();
    },
    toggleBox: function toggleBox() {},
    editIssuePriority: function editIssuePriority() {},
    projector: function projector() {
        GH.PresentationMode.iterateThroughPresentationModes(GH.PresentationMode.allModes);
    },

    // Issue specific operations
    viewIssue: function viewIssue() {
        GH.IssueOperationShortcuts.viewSelectedIssue();
    },
    editIssue: function editIssue() {
        GH.IssueOperationShortcuts.editSelectedIssue();
    },
    assignIssue: function assignIssue() {
        GH.IssueOperationShortcuts.assignSelectedIssue();
    },
    assignIssueToMe: function assignIssueToMe() {
        GH.IssueOperationShortcuts.assignSelectedIssueToMe();
    },
    commentIssue: function commentIssue() {
        GH.IssueOperationShortcuts.commentSelectedIssue();
    },
    editIssueLabels: function editIssueLabels() {
        GH.IssueOperationShortcuts.editSelectedIssueLabels();
    },
    showOperationsDialog: function showOperationsDialog() {
        GH.IssueOperationShortcuts.showOperationsDialog();
    },
    sendToTop: function sendToTop(source) {
        if (GH.WorkController.isActive()) {
            GH.WorkKBShortcuts.sendToTop(source);
        } else if (GH.PlanController.isActive()) {
            GH.PlanKBShortcuts.sendToTop(source);
        }
    },
    sendToBottom: function sendToBottom(source) {
        if (GH.WorkController.isActive()) {
            GH.WorkKBShortcuts.sendToBottom(source);
        } else if (GH.PlanController.isActive()) {
            GH.PlanKBShortcuts.sendToBottom(source);
        }
    },

    // Navigation
    nextIssue: function nextIssue() {
        if (GH.WorkController.isActive()) {
            GH.WorkKBNavigation.selectNextIssue();
        } else if (GH.PlanController.isActive()) {
            GH.BacklogSelectionController.selectNextIssue();
        }
    },
    previousIssue: function previousIssue() {
        if (GH.WorkController.isActive()) {
            GH.WorkKBNavigation.selectPreviousIssue();
        } else if (GH.PlanController.isActive()) {
            GH.BacklogSelectionController.selectPreviousIssue();
        }
    },
    nextBox: function nextBox() {
        if (GH.WorkController.isActive()) {
            GH.WorkKBNavigation.selectNextColumn();
        }
    },
    previousBox: function previousBox() {
        if (GH.WorkController.isActive()) {
            GH.WorkKBNavigation.selectPreviousColumn();
        }
    },
    toggleSwimlanes: function toggleSwimlanes() {
        if (GH.WorkController.isActive()) {
            GH.WorkKBNavigation.toggleSwimlanes();
        }
    },
    planMode: function planMode() {
        if (GH.RapidBoard.State.isPlanModeAvailable()) {
            GH.RapidBoard.ViewController.setMode('plan');
        } else {
            this.workMode();
        }
    },
    workMode: function workMode() {
        GH.RapidBoard.ViewController.setMode('work');
    },
    reportMode: function reportMode() {
        GH.RapidBoard.ViewController.setMode('report');
    },

    // Work specific shortcuts
    toggleIssue: function toggleIssue() {
        if (GH.WorkController.isActive()) {
            GH.WorkController.toggleDetailsView();
        } else if (GH.PlanController.isActive()) {
            GH.PlanController.toggleDetailsView();
        }
    }
};

/**
 * Handles Ctrl+F, firing a event for analytics
 */
AJS.$(document).bind('keydown');