define("jira-agile/rapid/configuration/restful-table-extensions", [
    "aui/restful-table",
    "jquery",
    "underscore"
], function (RestfulTable, $, _) {
    "use strict";

    const Util = {};

    Util.TextAreaEditView = RestfulTable.CustomEditView.extend({
        render: function (renderData) {
            return $('<textarea class="textarea"></textarea>')
                .attr('name', renderData.name)
                .text(renderData.value || '');
        }
    });

    Util.JQLEditView = RestfulTable.CustomEditView.extend({
        initialize: function () {
            RestfulTable.CustomEditView.prototype.initialize.apply(this, arguments);
            if (!this.namespace) {
                throw "You must provide a namespace. please extend JQLEditView";
            }
        },
        render: function (renderData) {
            return $(GH.tpl.inlineeditfield.renderJQLAutocomplete(_.extend({
                namespace: this.namespace,
                id: this.model.attributes.id
            }, renderData)));
        }
    });

    return Util;
});

AJS.namespace("GH.RapidBoard.Config.Util", null, require("jira-agile/rapid/configuration/restful-table-extensions"));

