AJS.test.require('com.pyxis.greenhopper.jira:gh-manage-boards', function () {
    var ManageBoardsView = require("jira-agile/rapid/configuration/manage-boards-view");
    var Events = require("jira-agile/rapid/events");
    var $ = require("jquery");

    var generateBoards = function generateBoards(number) {
        var boards = [];
        for (var i = 1; i <= number; i++) {
            boards.push({
                'id': i,
                'name': 'Boards ' + i,
                'canEdit': true,
                'sprintSupportEnabled': false,
                'filter': {
                    'id': i,
                    'name': 'Filter for board ' + i,
                    'permissionEntries': [{
                        'values': [{
                            'type': 'Project',
                            'name': 'Project ' + i
                        }]
                    }]
                },
                'renderableBoardAdmins': {
                    'userKeys': [{
                        'key': 'admin',
                        'displayName': 'admin'
                    }]
                }
            });
        }
        return boards;
    };
    module('ManageBoardsView', {
        setup: function setup() {

            this.generateBoards = generateBoards;
            this.recentCategory = { id: 'recent', name: 'Recent' };
            this.allCategory = { id: 'all', name: 'All' };
            this.currentCategory = this.recentCategory;
            this.boardCategories = [this.recentCategory, this.allCategory];
            this.currentBoards = this.generateBoards(10);
            this.paginationState = {
                totalPages: 1,
                firstPage: 1,
                lastPage: 1
            };

            this.model = _.extend(new Events(), {
                isEmpty: sinon.stub().returns(false),
                getCurrentCategory: sinon.stub().returns(this.currentCategory),
                getCurrentBoards: sinon.stub().returns(this.currentBoards),
                getBoardsCategories: sinon.stub().returns(this.boardCategories),
                getFilterState: sinon.stub().returns({ textFilter: '', typeFilter: [] }),
                isFilterable: sinon.stub().returns(true),
                getPaginationState: sinon.stub().returns(this.paginationState),
                isPopulated: sinon.stub().returns(true),
                typeFilter: []
            });

            this.$container = $('<header id="ghx-header" class="aui-page-header"></header>' + '<div id="ghx-content-main" class="ghx-content-main">' + '<div class="aui-page-panel" id="manage-boards-page">' + '<div class="aui-page-panel-inner"></div>' + '</div>' + '</div>');
            this.$container.appendTo($('#qunit-fixture'));

            this.initView = function initView(triggerChangeEvent) {
                triggerChangeEvent = typeof triggerChangeEvent !== 'undefined' ? triggerChangeEvent : true;
                this.view = new ManageBoardsView();
                this.view.init(this.model);

                if (triggerChangeEvent) {
                    this.model.trigger('change:boards');
                }
            }.bind(this);
        }
    });

    test('should hide sidebar when there are no recent boards', function () {
        this.model.getBoardsCategories.returns([this.allCategory]);
        this.initView();

        equal(this.$container.find('.aui-page-panel-nav').hasClass('hidden'), true);
    });

    test('should render current boards when model triggers change event', function () {
        this.initView(false);

        this.model.trigger('change');
        equal(this.$container.find('.boards-list tr').length, 0);

        this.model.trigger('change:boards');
        equal(this.$container.find('.boards-list tr').length, 10);

        this.model.getCurrentBoards.returns(this.generateBoards(5));
        this.model.trigger('change:boards');
        equal(this.$container.find('.boards-list tr').length, 5);
    });

    test('should trigger category change event only when we change category', function () {
        this.initView();

        var changeHdlr = sinon.spy();
        this.view.on('filter:category', changeHdlr);

        this.$container.find('.aui-page-panel-nav li a:eq(0)').click();
        sinon.assert.notCalled(changeHdlr);

        this.$container.find('.aui-page-panel-nav li a:eq(1)').click();
        sinon.assert.calledOnce(changeHdlr);
        sinon.assert.calledWith(changeHdlr, 'all');

        this.model.getCurrentCategory.returns(this.allCategory);
        this.$container.find('.aui-page-panel-nav li a:eq(0)').click();
        sinon.assert.calledTwice(changeHdlr);
        sinon.assert.calledWith(changeHdlr, 'recent');
    });

    test('should update UI with selected category', function () {
        this.initView();

        var $selected = this.$container.find('.aui-page-panel-nav li.aui-nav-selected');
        equal($selected.length, 1);
        equal($selected.children('a').data('itemId'), 'recent');

        this.model.getCurrentCategory.returns(this.allCategory);
        this.model.trigger('change:boards');

        $selected = this.$container.find('.aui-page-panel-nav li.aui-nav-selected');
        equal($selected.length, 1);
        equal($selected.children('a').data('itemId'), 'all');
    });

    test('should hide filtering when category is not filterable', function () {
        this.initView();

        var $filter = this.$container.find('.filter-form');

        equal($filter.hasClass('hidden'), false);

        this.model.isFilterable.returns(false);
        this.model.trigger('change:boards');

        equal($filter.hasClass('hidden'), true);
    });

    test('should trigger event when filtering by board type', function () {
        this.initView();

        var $typeFilters = this.$container.find('#board-types li a');
        var $typeCheckboxes = $typeFilters.find('input');
        var changeHdlr = sinon.spy();
        this.view.on('filter:type', changeHdlr);

        var clock = sinon.useFakeTimers();
        $typeFilters.eq(0).click();
        clock.tick(1);
        sinon.assert.calledOnce(changeHdlr);
        sinon.assert.calledWith(changeHdlr, [$typeCheckboxes.eq(0).val()]);

        $typeFilters.eq(1).click();
        clock.tick(1);
        sinon.assert.calledTwice(changeHdlr);
        sinon.assert.calledWith(changeHdlr, [$typeCheckboxes.eq(0).val(), $typeCheckboxes.eq(1).val()]);
        clock.restore();
    });

    test('should render empty view when there are no boards', function () {
        this.model.isEmpty.returns(true);
        this.initView();

        equal(this.$container.find('.ghx-notify').length, 1);
    });

    test('should render no matches view when there are no results', function () {
        this.model.getCurrentBoards.returns([]);
        this.initView();

        equal(this.$container.find('.boards-list tr').length, 1);
        equal(this.$container.find('.boards-list tr.boards-empty-row').length, 1);
    });

    test('should trigger event when filtering boards by text', function () {
        var clock = sinon.useFakeTimers();

        this.initView();

        var changeHdlr = sinon.spy();
        this.view.on('filter:text', changeHdlr);
        var $filterInput = this.$container.find('.boards-filter-container .text');
        $filterInput.val('test').trigger('input');

        sinon.assert.notCalled(changeHdlr);
        clock.tick(290);
        sinon.assert.notCalled(changeHdlr);
        clock.tick(10);
        sinon.assert.calledOnce(changeHdlr);
        sinon.assert.calledWith(changeHdlr, 'test');

        clock.restore();
    });

    test('should trigger event when page is changed', function () {
        this.model.getPaginationState.returns({
            totalPages: 5,
            firstPage: 1,
            lastPage: 5
        });

        this.initView();
        var changeHdlr = sinon.spy();
        this.view.on('change:page', changeHdlr);
        var $pages = this.$container.find('.pagination li a');

        $pages.eq(2).click();
        sinon.assert.calledOnce(changeHdlr);
        sinon.assert.calledWith(changeHdlr, 2);

        $pages.eq(4).click();
        sinon.assert.calledTwice(changeHdlr);
        sinon.assert.calledWith(changeHdlr, 4);
    });

    test('should properly handle copy and delete actions', function () {
        this.initView();
        GH.ViewActions.actionCopy = sinon.spy();
        GH.RapidBoard.DeleteDialog.showDeleteDialog = sinon.spy();
        GH.UserData.hasUser = sinon.stub().returns(false);

        equal(this.$container.find('.boards-list tr:eq(2) .js-copy-board-action').length, 0);

        GH.UserData.hasUser = sinon.stub().returns(true);
        this.view.render();

        this.$container.find('.boards-list tr:eq(2) .js-copy-board-action').click();
        sinon.assert.calledOnce(GH.ViewActions.actionCopy);
        sinon.assert.calledWith(GH.ViewActions.actionCopy, this.currentBoards[2].id.toString(), this.currentBoards[2].name);

        this.$container.find('.boards-list tr:eq(5) .js-delete-board-action').click();
        sinon.assert.calledOnce(GH.RapidBoard.DeleteDialog.showDeleteDialog);
        sinon.assert.calledWith(GH.RapidBoard.DeleteDialog.showDeleteDialog, this.currentBoards[5].id.toString(), this.currentBoards[5].name);
    });
});