define("jira-agile/rapid/configuration/manage-boards-service", ["jira-agile/rapid/ajax"], function(Ajax) {
    "use strict";

    return {

        /**
         * Searches for boards using the given search term.
         * Optionally confines search to the top n boards specified by maxResults
         *
         * @param {String} searchTerm
         * @param {Number} maxResults
         * @returns {Deferred}
         */
        searchBoards: function (searchTerm, maxResults) {
            return Ajax.get({
                url: '/rapidviews/search',
                data: {
                    query: searchTerm,
                    maxResults: maxResults
                }
            }, 'searchBoards');
        },

        /**
         * Fetches the recent boards of the currently logged in user.
         */
        getRecentBoards: function () {
            return Ajax.get({
                url: '/rapidviews/recent'
            }, 'getRecentBoards');
        },

        /**
         * Fetches the config model for the logged in user.
         *
         */
        getConfig: function () {
            return Ajax.get({
                url: '/rapidviews/config'
            }, 'getConfig');
        },

        /**
         * Fetches all the boards
         */
        getViewsData: function () {
            return Ajax.get({
                url: '/rapidviews/viewsData'
            }, 'getAllRapidBoards');
        }
    };
});

AJS.namespace('GH.ManageBoards.manageBoardsService', null, require("jira-agile/rapid/configuration/manage-boards-service"));