define('jira-agile/rapid/configuration/manage-boards-controller', ['jira-agile/rapid/configuration/manage-boards-view'], function(ManageBoardsView) {
    function ManageBoardsController() {}

    const ManageBoardsModel = GH.ManageBoards.ManageBoardsModel;
    const manageBoardsService = GH.ManageBoards.manageBoardsService;

    ManageBoardsController.prototype = {
        init: function (options) {
            var recentBoards = options && options.recentBoards || [];

            this.model = new ManageBoardsModel();
            this.model.setRecentBoards(recentBoards);

            this.view = new ManageBoardsView();
            this.view.init(this.model);

            this.view.on('change:page', function (page) {
                this.model.changePage(page);
            }.bind(this));

            this.view.on('filter:text', function (textFilter) {
                this.model.setTextFilter(textFilter);
                this.model.filterBoards();
            }.bind(this));

            this.view.on('filter:type', function (filteredTypes) {
                this.model.setTypeFilter(filteredTypes);
                this.model.filterBoards();
            }.bind(this));

            this.view.on('filter:category', function (categoryId) {
                this.model.setCurrentCategory(categoryId);
            }.bind(this));

            this.view.render();

            manageBoardsService.getViewsData().done(function (data) {
                this.model.populate(data.views);
                GH.RapidViewConfig.storeGlobalConfig(data.globalConfig);
                this.view.renderBoardsActions();
            }.bind(this));
        }
    };

    return ManageBoardsController;
});

AJS.namespace('GH.ManageBoards.ManageBoardsController', null, require('jira-agile/rapid/configuration/manage-boards-controller'));
