AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common-base", "com.pyxis.greenhopper.jira:gh-rapid-config"], function () {
    var CardLayoutConfigTable = require('jira-agile/rapid/configuration/card-layout-config-table');
    var $ = require('jquery');

    module('CardLayoutConfigTable', {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        },
        getTableBody: function getTableBody() {
            return $('#qunit-fixture tbody.ui-sortable');
        },
        getAddFieldSelect: function getAddFieldSelect() {
            return $('#qunit-fixture tbody.aui-restfultable-create select');
        }
    });

    test('Renders the table with the correct fields', function () {
        var configTable = new CardLayoutConfigTable('planMode', {
            canEdit: true,
            availableFields: [],
            currentFields: [{ mode: 'workMode', name: 'Field 1' }, { mode: 'planMode', name: 'Field 2' }]
        }, '#qunit-fixture');
        configTable.render();

        var tableBody = this.getTableBody();
        strictEqual(tableBody.find('tr').length, 1, 'Only 1 row was rendered');
        ok(tableBody.find('tr').text().indexOf('Field 2') >= 0, 'Row contains name of added field');
        strictEqual(this.getAddFieldSelect().is(':visible'), false, 'No available fields so the add field select is hidden');
    });

    test('Successful AJAX call sets available fields', function () {
        GH.Test.respondToGetWith200(this, '/cardlayout/(.*)/(.*)/available', { fields: [{ mode: 'workMode', name: 'Field 1' }] });

        var configTable = new CardLayoutConfigTable('workMode', {
            canEdit: true,
            availableFields: [],
            currentFields: [{ mode: 'workMode', name: 'Field 2' }]
        }, '#qunit-fixture');
        configTable.render();

        this.server.respond();

        strictEqual(this.getAddFieldSelect().is(':visible'), true, 'Fields are made available after AJAX request');
    });

    test('Add and delete functions are not available if canEdit: false', function () {
        // A basic test that the expected UI components are present. Not attempting to test RestfulTable.
        var configTable = new CardLayoutConfigTable('workMode', {
            canEdit: false,
            availableFields: [{ mode: 'workMode', name: 'Field 1' }],
            currentFields: [{ mode: 'workMode', name: 'Field 2' }]
        }, '#qunit-fixture');
        configTable.render();

        strictEqual(this.getAddFieldSelect().is(':visible'), false, 'No edit permission so the add field select is hidden');
        strictEqual(this.getTableBody().find('tr .aui-restfultable-delete').length, 0, 'No edit permission so delete buttons are not present');
    });
    test('Add and delete functions are not available if canEdit: false', function () {
        // A basic test that the expected UI components are present. Not attempting to test RestfulTable.
        var configTable = new CardLayoutConfigTable('workmode', {
            canEdit: false,
            availableFields: [{ mode: 'workmode', name: 'Field 1' }],
            currentFields: [{ mode: 'workmode', name: 'Field 2' }]
        }, '#qunit-fixture');
        configTable.render();

        strictEqual(this.getAddFieldSelect().is(':visible'), false, 'No edit permission so the add field select is hidden');
        strictEqual(this.getTableBody().find('tr .aui-restfultable-delete').length, 0, 'No edit permission so delete buttons are not present');
    });

    test('400 validation error displays the server error in an AUI message', function () {
        GH.Test.respondToGetWith200(this, '/cardlayout/(.*)/(.*)/available', { fields: [{ mode: 'workmode', name: 'Field 1' }] });
        GH.Test.respondWith(this, '/cardlayout/(.*)/(.*)/field', { errors: { cardlayoutConfig: 'an error occurred' } }, 'POST', 400);

        var configTable = new CardLayoutConfigTable('workmode', {
            canEdit: true,
            availableFields: [{ mode: 'workmode', name: 'Field 1' }],
            currentFields: [{ mode: 'workmode', name: 'Field 2' }]
        }, '#qunit-fixture');
        configTable.render();
        this.server.respond();
        configTable.el.find('.aui-restfultable-operations .aui-button[value="aui.words.add"]').click();

        this.server.respond();
        var message = configTable.el.find('.aui-message');
        ok(message.length > 0, 'Message exists');
        strictEqual(message.text(), 'an error occurred', 'Error from server is displayed correctly');
    });

    test('empty available fields response disables the add button', function () {
        GH.Test.respondToGetWith200(this, '/cardlayout/(.*)/(.*)/available', { fields: [] });
        var configTable = new CardLayoutConfigTable('workmode', {
            canEdit: true,
            availableFields: [{ mode: 'workmode', name: 'Field 1' }],
            currentFields: [{ mode: 'workmode', name: 'Field 2' }]
        }, '#qunit-fixture');
        configTable.render();
        this.server.respond();
        var addButton = configTable.el.find('.aui-restfultable-operations .aui-button[value="aui.words.add"]');
        strictEqual(addButton.attr('disabled'), 'disabled', 'Add button is disabled');
    });

    test('row is not removed when a 404 is returned from deleting a field', function () {
        GH.Test.respondToGetWith200(this, '/cardlayout/(.*)/(.*)/available', { fields: [] });
        GH.Test.respondWith(this, '/cardlayout/(.*)/(.*)/field', { errors: { cardlayoutConfig: 'an error occurred' } }, 'DELETE', 404);
        var configTable = new CardLayoutConfigTable('workmode', {
            canEdit: true,
            availableFields: [{ mode: 'workmode', name: 'Field 1' }],
            currentFields: [{ mode: 'workmode', name: 'Field 2' }]
        }, '#qunit-fixture');
        configTable.render();

        var rowsBeforeDelete = configTable.restfulTable.getModels();
        configTable.el.find('.aui-restfultable-delete').click();
        this.server.respond();
        var rowsAfterDelete = configTable.restfulTable.getModels();

        deepEqual(rowsBeforeDelete, rowsAfterDelete, 'table contents do not match before and after the failed delete');
    });
});