AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid-common", function() {
    const Util = require('jira-agile/rapid/util');
    const $ = require('jquery');

    module("Util tests", {
        testRoundToDecimalPlaces: function(number, decimalPlaces, expected) {
            strictEqual(Util.roundToDecimalPlaces(number, decimalPlaces), expected,
                "Rounding " + number + " to " + decimalPlaces + " decimal places");
        },

        testArraySwap: function(array, j, k) {
            var elJ = array[j],
                elK = array[k],
                original = array.slice(0);

            strictEqual(Util.swapArrayItems(array, j, k), true);
            strictEqual(array[k], elJ);
            strictEqual(array[j], elK);
            for (var i = 0; i < original.length; i++) {
                if (i !== j && i !== k) {
                    strictEqual(array[i], original[i]);
                }
            }
        }
    });

    test("roundToDecimalPlaces", function() {
        this.testRoundToDecimalPlaces(undefined, 1, undefined);
        this.testRoundToDecimalPlaces(10, 1, 10);
        this.testRoundToDecimalPlaces(10.4, 0, 10);
        this.testRoundToDecimalPlaces(10.4, 1, 10.4);
        this.testRoundToDecimalPlaces(10.5, 0, 11);
        this.testRoundToDecimalPlaces(10.15, 1, 10.2);
        this.testRoundToDecimalPlaces(-10.15, 1, -10.1);
        this.testRoundToDecimalPlaces(-10.16, 1, -10.2);
        this.testRoundToDecimalPlaces(-10.15, 2, -10.15);
        this.testRoundToDecimalPlaces(0.01, 2, 0.01);
        this.testRoundToDecimalPlaces(0.005, 2, 0.01);
        this.testRoundToDecimalPlaces(35.855, 2, 35.86);
        this.testRoundToDecimalPlaces(35.995, 2, 36);
        this.testRoundToDecimalPlaces(77777777802, 2, 77777777802);
    });

    test("swapArrayItems Errors", function() {
        // not enough items in array
        strictEqual(Util.swapArrayItems(), false);
        strictEqual(Util.swapArrayItems([], 0, 1), false);
        strictEqual(Util.swapArrayItems([1], 0, 1), false);

        // indices are the same
        strictEqual(Util.swapArrayItems([1, 2], 0, 0), false);

        // indices out of bounds
        strictEqual(Util.swapArrayItems([1, 2], -1, 0), false);
        strictEqual(Util.swapArrayItems([1, 2], 0, 2), false);
    });

    test("swapArrayItems Happy", function() {
        var array = [{id: 1}, {id: 2}];
        this.testArraySwap(array, 0, 1);
        this.testArraySwap(array, 1, 0);

        array.push({id: 3});
        this.testArraySwap(array, 0, 2);
        this.testArraySwap(array, 1, 2);
        this.testArraySwap(array, 2, 0);
        this.testArraySwap(array, 2, 1);
        this.testArraySwap(array, 1, 0);
    });

    test('$.Deferred andThen() function', function () {
        let deferred = $.Deferred();
        deferred.resolve('done');
        deferred.promise().andThen(function (data) {
            strictEqual(data, 'done');
        });
    });
});
