define('jira-agile/rapid/url-format', ['underscore', 'jira-agile/rapid/ajax'], function(_, Ajax) {
    const UrlFormat = {};

    UrlFormat.defaultContextPath = "";

    /**
     * Takes a URL, which may be either absolute or relative, and prepends the Base URL of JIRA (i.e. context path)
     * if necessary to make it a valid URL.
     *
     * This is required when building URLs for images which are served by JIRA e.g. Priority Icon.
     *
     * @param url
     */
    UrlFormat.prependBaseUrl = function(url) {
        if (url && url.indexOf('http://') !== 0 && url.indexOf('https://') !== 0) {
            var cp = (Ajax && Ajax.CONTEXT_PATH) ? Ajax.CONTEXT_PATH : UrlFormat.defaultContextPath;
            url = cp + url;
        }
        return url;
    };

    /**
     * Takes a collection of issues and returns the JIRA Issue Navigator URL for that set of issues.
     *
     * @param {Object[]} issues
     * @returns {String}
     */
    UrlFormat.getUrlForIssues = function(issues) {
        var issueList = _.compact(_.pluck(issues, 'id')).join(',');
        var jql = issueList !== '' ? 'id in (' + issueList + ')' : '';
        return UrlFormat.prependBaseUrl('/issues/?jql=' + encodeURIComponent(jql));
    };

    return UrlFormat;
});

AJS.namespace('GH.UrlFormat', null, require('jira-agile/rapid/url-format'));
