/**
 * History.js Core
 * @author Benjamin Arthur Lupton <contact@balupton.com>
 * @copyright 2010-2011 Benjamin Arthur Lupton <contact@balupton.com>
 * @license New BSD License <http://creativecommons.org/licenses/BSD/>
 */
!function(e,t){"use strict";var a=e.console||t,r=e.document,n=e.navigator,o=e.amplify||!1,i=e.setTimeout,s=e.clearTimeout,u=e.setInterval,l=e.JSON,d=e.History=e.History||{},c=e.history;if(l.stringify=l.stringify||l.encode,l.parse=l.parse||l.decode,"undefined"!=typeof d.init)throw new Error("History.js Core has already been loaded...");d.init=function(){return"undefined"!=typeof d.Adapter&&("undefined"!=typeof d.initCore&&d.initCore(),"undefined"!=typeof d.initHtml4&&d.initHtml4(),!0)},d.initCore=function(){if("undefined"!=typeof d.initCore.initialized)return!1;if(d.initCore.initialized=!0,d.options=d.options||{},d.options.hashChangeInterval=d.options.hashChangeInterval||100,d.options.safariPollInterval=d.options.safariPollInterval||500,d.options.doubleCheckInterval=d.options.doubleCheckInterval||500,d.options.storeInterval=d.options.storeInterval||1e3,d.options.busyDelay=d.options.busyDelay||250,d.options.debug=d.options.debug||!1,d.options.initialTitle=d.options.initialTitle||r.title,d.debug=function(){d.options.debug&&d.log.apply(d,arguments)},d.log=function(){var e,t,n,o=!("undefined"==typeof a||"undefined"==typeof a.log||"undefined"==typeof a.log.apply),i=r.getElementById("log");if(o){var s=Array.prototype.slice.call(arguments);e=s.shift(),"undefined"!=typeof a.debug?a.debug.apply(a,[e,s]):a.log.apply(a,[e,s])}else e="\n"+arguments[0]+"\n";for(t=1,n=arguments.length;t<n;++t){var u=arguments[t];if("object"==typeof u&&"undefined"!=typeof l)try{u=l.stringify(u)}catch(e){}e+="\n"+u+"\n"}return i?(i.value+=e+"\n-----\n",i.scrollTop=i.scrollHeight-i.clientHeight):o||alert(e),!0},/**
		 * History.getInternetExplorerMajorVersion()
		 * Get's the major version of Internet Explorer
		 * @return {integer}
		 * @license Public Domain
		 * @author Benjamin Arthur Lupton <contact@balupton.com>
		 * @author James Padolsey <https://gist.github.com/527683>
		 */
d.getInternetExplorerMajorVersion=function(){var e=d.getInternetExplorerMajorVersion.cached="undefined"!=typeof d.getInternetExplorerMajorVersion.cached?d.getInternetExplorerMajorVersion.cached:function(){for(var e=3,t=r.createElement("div"),a=t.getElementsByTagName("i");(t.innerHTML="<!--[if gt IE "+ ++e+"]><i></i><![endif]-->")&&a[0];);return e>4&&e}();return e},/**
		 * History.isInternetExplorer()
		 * Are we using Internet Explorer?
		 * @return {boolean}
		 * @license Public Domain
		 * @author Benjamin Arthur Lupton <contact@balupton.com>
		 */
d.isInternetExplorer=function(){var e=d.isInternetExplorer.cached="undefined"!=typeof d.isInternetExplorer.cached?d.isInternetExplorer.cached:Boolean(d.getInternetExplorerMajorVersion());return e},d.emulated={pushState:!Boolean(e.history&&e.history.pushState&&e.history.replaceState&&!(/ Mobile\/([1-7][a-z]|(8([abcde]|f(1[0-8]))))/i.test(n.userAgent)||/AppleWebKit\/5([0-2]|3[0-2])/i.test(n.userAgent))),hashChange:Boolean(!("onhashchange"in e||"onhashchange"in r)||d.isInternetExplorer()&&d.getInternetExplorerMajorVersion()<8)},d.enabled=!d.emulated.pushState,d.bugs={setHash:Boolean(!d.emulated.pushState&&"Apple Computer, Inc."===n.vendor&&/AppleWebKit\/5([0-2]|3[0-3])/.test(n.userAgent)),safariPoll:Boolean(!d.emulated.pushState&&"Apple Computer, Inc."===n.vendor&&/AppleWebKit\/5([0-2]|3[0-3])/.test(n.userAgent)),ieDoubleCheck:Boolean(d.isInternetExplorer()&&d.getInternetExplorerMajorVersion()<8),hashEscape:Boolean(d.isInternetExplorer()&&d.getInternetExplorerMajorVersion()<7)},d.isEmptyObject=function(e){for(var t in e)return!1;return!0},d.cloneObject=function(e){var t,a;return e?(t=l.stringify(e),a=l.parse(t)):a={},a},d.getRootUrl=function(){var e=r.location.protocol+"//"+(r.location.hostname||r.location.host);return r.location.port&&(e+=":"+r.location.port),e+="/"},d.getBaseHref=function(){var e=r.getElementsByTagName("base"),t=null,a="";return 1===e.length&&(t=e[0],a=t.href.replace(/[^\/]+$/,"")),a=a.replace(/\/+$/,""),a&&(a+="/"),a},d.getBaseUrl=function(){var e=d.getBaseHref()||d.getBasePageUrl()||d.getRootUrl();return e},d.getPageUrl=function(){var e=d.getState(!1,!1),t=(e||{}).url||r.location.href,a=t.replace(/\/+$/,"").replace(/[^\/]+$/,function(e,t,a){return/\./.test(e)?e:e+"/"});return a},d.getBasePageUrl=function(){var e=r.location.href.replace(/[#\?].*/,"").replace(/[^\/]+$/,function(e,t,a){return/[^\/]$/.test(e)?"":e}).replace(/\/+$/,"")+"/";return e},d.getFullUrl=function(e,t){var a=e,r=e.substring(0,1);return t="undefined"==typeof t||t,/[a-z]+\:\/\//.test(e)||(a="/"===r?d.getRootUrl()+e.replace(/^\/+/,""):"#"===r?d.getPageUrl().replace(/#.*/,"")+e:"?"===r?d.getPageUrl().replace(/[\?#].*/,"")+e:t?d.getBaseUrl()+e.replace(/^(\.\/)+/,""):d.getBasePageUrl()+e.replace(/^(\.\/)+/,"")),a.replace(/\#$/,"")},d.getShortUrl=function(e){var t=e,a=d.getBaseUrl(),r=d.getRootUrl();return d.emulated.pushState&&(t=t.replace(a,"")),t=t.replace(r,"/"),d.isTraditionalAnchor(t)&&(t="./"+t),t=t.replace(/^(\.\/)+/g,"./").replace(/\#$/,"")},d.store=o?o.store("History.store")||{}:{},d.store.idToState=d.store.idToState||{},d.store.urlToId=d.store.urlToId||{},d.store.stateToId=d.store.stateToId||{},d.idToState=d.idToState||{},d.stateToId=d.stateToId||{},d.urlToId=d.urlToId||{},d.storedStates=d.storedStates||[],d.savedStates=d.savedStates||[],d.getState=function(e,t){"undefined"==typeof e&&(e=!0),"undefined"==typeof t&&(t=!0);var a=d.getLastSavedState();return!a&&t&&(a=d.createStateObject()),e&&(a=d.cloneObject(a),a.url=a.cleanUrl||a.url),a},d.getIdByState=function(e){var t=d.extractId(e.url);if(!t){var a=d.getStateString(e);if("undefined"!=typeof d.stateToId[a])t=d.stateToId[a];else if("undefined"!=typeof d.store.stateToId[a])t=d.store.stateToId[a];else{for(;;)if(t=(new Date).getTime()+~~(1e3*Math.random()),"undefined"==typeof d.idToState[t]&&"undefined"==typeof d.store.idToState[t])break;d.stateToId[a]=t,d.idToState[t]=e}}return t},d.normalizeState=function(e){if(e&&"object"==typeof e||(e={}),"undefined"!=typeof e.normalized)return e;e.data&&"object"==typeof e.data||(e.data={});var t={};t.normalized=!0,t.title=e.title||"",t.url=d.getFullUrl(d.unescapeString(e.url||r.location.href)),t.hash=d.getShortUrl(t.url),t.data=d.cloneObject(e.data),t.id=d.getIdByState(t),t.cleanUrl=t.url.replace(/\??\&_suid.*/,""),t.url=t.cleanUrl;var a=!d.isEmptyObject(t.data);return(t.title||a)&&(t.hash=d.getShortUrl(t.url).replace(/\??\&_suid.*/,""),/\?/.test(t.hash)||(t.hash+="?"),t.hash+="&_suid="+t.id),t.hashedUrl=d.getFullUrl(t.hash),(d.emulated.pushState||d.bugs.safariPoll)&&d.hasUrlDuplicate(t)&&(t.url=t.hashedUrl),t},d.createStateObject=function(e,t,a){var r={data:e,title:t,url:a};return r=d.normalizeState(r)},d.getStateById=function(e){e=String(e);var a=d.idToState[e]||d.store.idToState[e]||t;return a},d.getStateString=function(e){var t=d.normalizeState(e),a={data:t.data,title:e.title,url:e.url},r=l.stringify(a);return r},d.getStateId=function(e){var t=d.normalizeState(e),a=t.id;return a},d.getHashByState=function(e){var t,a=d.normalizeState(e);return t=a.hash},d.extractId=function(e){var t,a,r;return a=/(.*)\&_suid=([0-9]+)$/.exec(e),r=a?a[1]||e:e,t=a?String(a[2]||""):"",t||!1},d.isTraditionalAnchor=function(e){var t=!/[\/\?\.]/.test(e);return t},d.extractState=function(e,t){var a=null;t=t||!1;var r=d.extractId(e);if(r&&(a=d.getStateById(r)),!a){var n=d.getFullUrl(e);r=d.getIdByUrl(n)||!1,r&&(a=d.getStateById(r)),a||!t||d.isTraditionalAnchor(e)||(a=d.createStateObject(null,null,n))}return a},d.getIdByUrl=function(e){var a=d.urlToId[e]||d.store.urlToId[e]||t;return a},d.getLastSavedState=function(){return d.savedStates[d.savedStates.length-1]||t},d.getLastStoredState=function(){return d.storedStates[d.storedStates.length-1]||t},d.hasUrlDuplicate=function(e){var t=!1,a=d.extractState(e.url);return t=a&&a.id!==e.id},d.storeState=function(e){return d.urlToId[e.url]=e.id,d.storedStates.push(d.cloneObject(e)),e},d.isLastSavedState=function(e){var t=!1;if(d.savedStates.length){var a=e.id,r=d.getLastSavedState(),n=r.id;t=a===n}return t},d.saveState=function(e){return!d.isLastSavedState(e)&&(d.savedStates.push(d.cloneObject(e)),!0)},d.getStateByIndex=function(e){var t=null;return t="undefined"==typeof e?d.savedStates[d.savedStates.length-1]:e<0?d.savedStates[d.savedStates.length+e]:d.savedStates[e]},d.getHash=function(){var e=d.unescapeHash(r.location.hash);return e},d.unescapeString=function(t){for(var a,r=t;;){if(a=e.unescape(r),a===r)break;r=a}return r},d.unescapeHash=function(e){var t=d.normalizeHash(e);return t=d.unescapeString(t)},d.normalizeHash=function(e){var t=e.replace(/[^#]*#/,"").replace(/#.*/,"");return t},d.setHash=function(e,t){if(t!==!1&&d.busy())return d.pushQueue({scope:d,callback:d.setHash,args:arguments,queue:t}),!1;var a=d.escapeHash(e);d.busy(!0);var n=d.extractState(e,!0);if(n&&!d.emulated.pushState)d.pushState(n.data,n.title,n.url,!1);else if(r.location.hash!==a)if(d.bugs.setHash){var o=d.getPageUrl();d.pushState(null,null,o+"#"+a,!1)}else r.location.hash=a;return d},d.escapeHash=function(t){var a=d.normalizeHash(t);return a=e.escape(a),d.bugs.hashEscape||(a=a.replace(/\%21/g,"!").replace(/\%26/g,"&").replace(/\%3D/g,"=").replace(/\%3F/g,"?")),a},d.getHashByUrl=function(e){var t=String(e).replace(/([^#]*)#?([^#]*)#?(.*)/,"$2");return t=d.unescapeHash(t)},d.setTitle=function(e){var t=e.title;if(!t){var a=d.getStateByIndex(0);a&&a.url===e.url&&(t=a.title||d.options.initialTitle)}try{r.getElementsByTagName("title")[0].innerHTML=t.replace("<","&lt;").replace(">","&gt;").replace(" & "," &amp; ")}catch(e){}return r.title=t,d},d.queues=[],d.busy=function(e){if("undefined"!=typeof e?d.busy.flag=e:"undefined"==typeof d.busy.flag&&(d.busy.flag=!1),!d.busy.flag){s(d.busy.timeout);var t=function(){if(!d.busy.flag)for(var e=d.queues.length-1;e>=0;--e){var a=d.queues[e];if(0!==a.length){var r=a.shift();d.fireQueueItem(r),d.busy.timeout=i(t,d.options.busyDelay)}}};d.busy.timeout=i(t,d.options.busyDelay)}return d.busy.flag},d.fireQueueItem=function(e){return e.callback.apply(e.scope||d,e.args||[])},d.pushQueue=function(e){return d.queues[e.queue||0]=d.queues[e.queue||0]||[],d.queues[e.queue||0].push(e),d},d.queue=function(e,t){return"function"==typeof e&&(e={callback:e}),"undefined"!=typeof t&&(e.queue=t),d.busy()?d.pushQueue(e):d.fireQueueItem(e),d},d.clearQueue=function(){return d.busy.flag=!1,d.queues=[],d},d.stateChanged=!1,d.doubleChecker=!1,d.doubleCheckComplete=function(){return d.stateChanged=!0,d.doubleCheckClear(),d},d.doubleCheckClear=function(){return d.doubleChecker&&(s(d.doubleChecker),d.doubleChecker=!1),d},d.doubleCheck=function(e){return d.stateChanged=!1,d.doubleCheckClear(),d.bugs.ieDoubleCheck&&(d.doubleChecker=i(function(){return d.doubleCheckClear(),d.stateChanged||e(),!0},d.options.doubleCheckInterval)),d},d.safariStatePoll=function(){var t,a=d.extractState(r.location.href);if(!d.isLastSavedState(a))return t=a,t||(t=d.createStateObject()),d.Adapter.trigger(e,"popstate"),d},d.back=function(e){return e!==!1&&d.busy()?(d.pushQueue({scope:d,callback:d.back,args:arguments,queue:e}),!1):(d.busy(!0),d.doubleCheck(function(){d.back(!1)}),c.go(-1),!0)},d.forward=function(e){return e!==!1&&d.busy()?(d.pushQueue({scope:d,callback:d.forward,args:arguments,queue:e}),!1):(d.busy(!0),d.doubleCheck(function(){d.forward(!1)}),c.go(1),!0)},d.go=function(e,t){var a;if(e>0)for(a=1;a<=e;++a)d.forward(t);else{if(!(e<0))throw new Error("History.go: History.go requires a positive or negative integer passed.");for(a=-1;a>=e;--a)d.back(t)}return d},d.saveState(d.storeState(d.extractState(r.location.href,!0))),o&&(d.onUnload=function(){var e,t=o.store("History.store")||{};t.idToState=t.idToState||{},t.urlToId=t.urlToId||{},t.stateToId=t.stateToId||{};for(e in d.idToState)d.idToState.hasOwnProperty(e)&&(t.idToState[e]=d.idToState[e]);for(e in d.urlToId)d.urlToId.hasOwnProperty(e)&&(t.urlToId[e]=d.urlToId[e]);for(e in d.stateToId)d.stateToId.hasOwnProperty(e)&&(t.stateToId[e]=d.stateToId[e]);d.store=t,o.store("History.store",t)},u(d.onUnload,d.options.storeInterval),d.Adapter.bind(e,"beforeunload",d.onUnload),d.Adapter.bind(e,"unload",d.onUnload)),d.emulated.pushState){var p=function(){};d.pushState=d.pushState||p,d.replaceState=d.replaceState||p}else d.onPopState=function(t){d.doubleCheckComplete();var a=d.getHash();if(a){var n=d.extractState(a||r.location.href,!0);return n?d.replaceState(n.data,n.title,n.url,!1):(d.Adapter.trigger(e,"anchorchange"),d.busy(!1)),d.expectedStateId=!1,!1}var o=!1;return t=t||{},"undefined"==typeof t.state&&("undefined"!=typeof t.originalEvent&&"undefined"!=typeof t.originalEvent.state?t.state=t.originalEvent.state||!1:"undefined"!=typeof t.event&&"undefined"!=typeof t.event.state&&(t.state=t.event.state||!1)),t.state=t.state||!1,o=t.state?d.getStateById(t.state):d.expectedStateId?d.getStateById(d.expectedStateId):d.extractState(r.location.href),o||(o=d.createStateObject(null,null,r.location.href)),d.expectedStateId=!1,d.isLastSavedState(o)?(d.busy(!1),!1):(d.storeState(o),d.saveState(o),d.setTitle(o),d.Adapter.trigger(e,"statechange"),d.busy(!1),!0)},d.Adapter.bind(e,"popstate",d.onPopState),d.pushState=function(t,a,r,n){if(d.getHashByUrl(r)&&d.emulated.pushState)throw new Error("History.js does not support states with fragement-identifiers (hashes/anchors).");if(n!==!1&&d.busy())return d.pushQueue({scope:d,callback:d.pushState,args:arguments,queue:n}),!1;d.busy(!0);var o=d.createStateObject(t,a,r);return d.isLastSavedState(o)?d.busy(!1):(d.storeState(o),d.expectedStateId=o.id,c.pushState(o.id,o.title,o.url),d.Adapter.trigger(e,"popstate")),!0},d.replaceState=function(t,a,r,n){if(d.getHashByUrl(r)&&d.emulated.pushState)throw new Error("History.js does not support states with fragement-identifiers (hashes/anchors).");if(n!==!1&&d.busy())return d.pushQueue({scope:d,callback:d.replaceState,args:arguments,queue:n}),!1;d.busy(!0);var o=d.createStateObject(t,a,r);return d.isLastSavedState(o)?d.busy(!1):(d.storeState(o),d.expectedStateId=o.id,c.replaceState(o.id,o.title,o.url),d.Adapter.trigger(e,"popstate")),!0},d.bugs.safariPoll&&u(d.safariStatePoll,d.options.safariPollInterval),"Apple Computer, Inc."!==n.vendor&&"Mozilla"!==(n.appCodeName||"")||(d.Adapter.bind(e,"hashchange",function(){d.Adapter.trigger(e,"popstate")}),d.getHash()&&d.Adapter.onDomLoad(function(){d.Adapter.trigger(e,"hashchange")}))},d.init()}(window);