/**
 * A scrubber is a component which produces a 100% high vertical line which follows the mouse as it moves.
 */
c3.scrubber = function() {

    var scrubberComponent =  c3.singular();

    /**
     * Reposition the scrubber line next to the mouse.
     */
    function refreshScrubber() {
        var mouse = scrubberComponent.parent().mouseCoordinates();

        scrubberComponent.elements()
            .attr('x1', mouse[0])
            .attr('x2', mouse[0]);

        if (!scrubberComponent.shouldHideScrubber()()) {
            scrubberComponent.elements()
                .style('visibility', '');
        }
    }

    /**
     * Hides the scrubber.
     */
    function hideScrubber() {
        scrubberComponent.elements()
            .style('visibility', 'hidden');
    }

    /**
     * Disables mouse interaction with the scrubber line.
     *
     * @param {d3.selection} selection The selection to disable mouse interaction for.
     */
    function disableMouseInteraction(selection) {
        selection
            .style('pointer-events', 'none');
    }

    /**
     * Initialise the component:
     *
     *  - Update the scrubber line on mousemove
     *  - Hide the scrubber line on mouseout
     *  - Prevent interaction with the line itself
     *
     * @param event
     */
    function initialise(event) {
        disableMouseInteraction(event.selection);
        this.interactiveLayer()
            .mousemove('scrubber', function() {
                refreshScrubber();
            })
            .mouseout(function() {
                hideScrubber();
            });
    }

    return scrubberComponent
        .elementTag('line')
        .enter(initialise)
        .extend(c3.withDimensions())
        .extend({
            interactiveLayer:   c3.prop(),
            shouldHideScrubber: c3.prop(function() {}),
            hideScrubber: hideScrubber
        })
        .update(function(event) {
            event.selection
                .attr('y1', 0)
                .attr('y2', this.height());
        });
};
