GADGET = {GH: {}};

GADGET.boardInitialized = false;

// we don't load AJS.Meta in old gadget plaform
// to make mommentjs still behave as excepted we have to hard code momentDateFormat and momentTimeFormat
// this problem should go away when we move to new gadget plaform (loading gadget into page as element instead of iframe)
GH.ChartTimeFrames.momentDateFormat = "DD/MMM/YY";
GH.ChartTimeFrames.momentTimeFormat = "DD/MMM/YY h:mm A";

GADGET.preInit = function (baseUrl) {
    // gadgets have a slightly different lifecycle/context because they're loaded in an iframe.
    // given that, we need to explicitly trigger the initialisation event when they load.
    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.trigger('pre-initialization');

    // redefine the context path
    GH.Ajax.CONTEXT_PATH = baseUrl;
};

GADGET.isWallboardMode = function () {
    return GH.gadget.utils.getViewName() == 'wallboard';
};

/**
 * Ajax requests for the template
 */
GADGET.templateArgs = function (baseUrl) {
    //Assign wallboard class here so errors also get this class in the body
    if (GADGET.isWallboardMode()) {
        AJS.$('body').addClass('wallboard');
    }
    return [];
};

/**
 * Gadget template function
 */
GADGET.template = function (gadget, args, baseUrl) {
    if (!GADGET.boardInitialized) {
        // initialize the actual rendering code
        GADGET.GH.init(gadget);
        GADGET.boardInitialized = true;
    }

    GADGET.GH.loadAndRender(gadget);
};

(function() {
    var AnalyticsTracker = require('jira-agile/rapid/analytics-tracker');
    /**
     * @type module:jira-agile/rapid/analytics-tracker
     */
    GADGET.GH.Analytics = new AnalyticsTracker("gh.report.versionreport.gadget");
})();

/**
 * Ajax requests to be executed for the descriptor
 */
GADGET.descriptorArgs = function (baseUrl) {
    return [
        {
            key: "rapidViews",
            ajaxOptions: baseUrl + "/rest/greenhopper/1.0/rapidview"
        }
    ];
};

/**
 * Gadget descriptor
 */
GADGET.descriptor = function (gadget, args, baseUrl) {
    //[GHS-2677]
    //Root cause is that the existing content is not cleared when an error is added as a result of a gadget refresh
    //To fix this we hide existing content when this class is appended into the body
    //Calling descriptor should remove class indicating invalidness
    AJS.$("body").removeClass('config-unavailable');

    return  {
        action: baseUrl + "/rest/greenhopper/1.0/gadgets/rapidview/pool/validate.json",
        theme: function () {
            if (gadgets.window.getViewportDimensions().width < 450) {
                return "gdt top-label";
            }
            else {
                return "gdt";
            }
        }(),
        fields: [
            GH.gadget.rapid.fields.rapidViewPicker(gadget, "rapidViewId", _.where(args.rapidViews.views, {sprintSupportEnabled: true})),
            GH.gadget.fields.checkbox(gadget, "showRapidViewName", 'gh.gadget.userpref.showrvname.name', gadget.getPref('showRapidViewName') == 'true'),
            GH.gadget.rapid.fields.versionPicker(gadget, 'versionId', 'rapidViewId', GH.gadget.rapid.server.loadVersionsByBoardId),
            GH.gadget.fields.checkbox(gadget, "showVersionName", 'gh.gadget.userpref.showvsname.name', gadget.getPref('showVersionName') == 'true'),
            AJS.gadget.fields.nowConfigured()
        ]
    };

};

GADGET.GH.init = function (gadget) {
    // this is the only way to prevent default error handling (non closable messages) inherited from common gadget library
    gadget.ajaxErrorHandler.handle404 = AJS.$.noop;
};

/**
 * Loads the rapid view config for the selected board (rapid view).
 *
 * @return {AJS.$.Promise} a promise of rapid view data
 */
GADGET.GH.loadConfig = function (gadget) {
    var rapidViewId = parseInt(gadget.getPref("rapidViewId"), 10);
    return GH.gadget.rapid.server.loadConfigByBoardId(rapidViewId);
};

/**
 * Loads all the open sprints for the selected board (rapid view).
 *
 * @return {AJS.$.Promise} sprints array promise.
 */
GADGET.GH.loadVersions = function (gadget) {
    var rapidViewId = parseInt(gadget.getPref("rapidViewId"), 10);
    return GH.gadget.rapid.server.loadVersionsByBoardId(rapidViewId);
};

GADGET.GH.loadAndRender = function (gadget) {

    // clear error message
    GH.Notification.clear();

    gadget.getView().html('<div id="gh"></div>');
    AJS.$('#gh').html(GH.tpl.board.x.renderRapidBoard());
    AJS.$('#ghx-report').html(GH.tpl.reportcontroller.renderReportView({
        shouldShowNavigation: true
    }));

    // load rapid view data (name, etc)
    var loadConfigPromise = GADGET.GH.loadConfig(gadget)
        .done(function (rapidViewData) {
            GADGET.GH.loadVersions(gadget).
                done(function (versions) {
                    var version = GADGET.GH.selectVersion(gadget, rapidViewData, versions);

                    // check whether we got version
                    if (version) {
                        GADGET.GH.showChart(gadget, rapidViewData, version);
                    } else {
                        GH.gadget.utils.showInlineWarning(gadget, gadget.getMsg('gh.gadget.version.error.can.not.find.version'));
                    }
                }).fail(function () {
                    GH.gadget.utils.showInlineWarning(gadget, gadget.getMsg('gh.gadget.version.error.can.not.load.versions'));
                });
        }).fail(function () {
            GH.gadget.utils.showInlineWarning(gadget, gadget.getMsg('gh.gadget.common.error.can.not.find.board.or.nopermission'));
        });
};

GADGET.GH.selectVersion = function (gadget, rapidViewData, versions) {

    // find the correct sprint
    var versionId = parseInt(gadget.getPref("versionId"), 10);
    if (_.isNaN(versionId)) {
        return null;
    }

    return _.findWhere(versions, {id: versionId });
};

GADGET.GH.showChart = function (gadget, rapidViewData, version) {
    var VersionReportChartController = require('jira-agile/rapid/ui/chart/version-report-chart-controller');
    var VersionReportView = require('jira-agile/rapid/ui/chart/version-report-view');

    AJS.$('#ghx-report').show();

    // configure chart and kick off loading
    VersionReportView.renderChartLoading();

    var showRapidViewName = gadget.getPref("showRapidViewName") === 'true';
    var showVersionName = gadget.getPref("showVersionName") === 'true';

    // configure the view for the gadget mode
    VersionReportView.setGadgetMode(true);
    VersionReportView.setWallboardMode(GADGET.isWallboardMode());

    VersionReportChartController.setRapidView(rapidViewData);
    VersionReportChartController.setVersionId(version.id);
    VersionReportChartController.show();

    // analytics for chart type
    GADGET.GH.Analytics.trigger('show');

    GADGET.GH.injectTitle(gadget, rapidViewData, showRapidViewName, showVersionName, version);

    var ratio = 16 / 9;
    var $content = AJS.$('#ghx-chart-content');
    var $header = AJS.$('#ghx-chart-header');

    var height = $content.width() / ratio;
    // in wallboard mode, we empirically found that it's better to remove the header height
    if (GADGET.isWallboardMode()) {
        height -= $header.height();
    }
    AJS.$('#ghx-chart-view').height(height);

    VersionReportChartController.onChartRendered  = function() {
        gadget.resize();
    };
};

/**
 * Set the gadget title to include the name of the selected Rapid View and version.
 *
 * @param {{name: string}} rapidViewData
 * @param {boolean} showRapidViewName
 * @param {boolean} showVersionName
 * @param {{name: string}} version
 */
GADGET.GH.injectTitle = function (gadget, rapidViewData, showRapidViewName, showVersionName, version) {
    if (showRapidViewName || showVersionName) {
        GADGET.GH.constructAndInsertGadgetHeader(gadget, rapidViewData, showRapidViewName, showVersionName, version);
    }
};

/**
 * Injects a title on top of the chart. We don't use the widget header here because in wallboard mode it will be hidden.
 *
 * @param {{name: string}} rapidViewData
 * @param {boolean} showRapidViewName
 * @param {boolean} showVersionName
 * @param {{name: string}} version
 */
GADGET.GH.constructAndInsertGadgetHeader = function (gadget, rapidViewData, showRapidViewName, showVersionName, version) {
    AJS.$('#ghx-chart-header')
        .html(GH.tpl.gadgets.renderBasicHeader({
            showTitle: showRapidViewName,
            showSubtitle: showVersionName,
            title: rapidViewData.name,
            subtitle: version.name,
            subtitleLabel: gadget.getMsg('gh.gadget.version.report.version'),
            subtitleLink: GH.Ajax.CONTEXT_PATH + '/browse/' + version.projectKey + '/fixforversion/' + version.id
        }));
};

GADGET.GH.versionListUpdatedHandler = function(newVersionList) {
    var $container = AJS.$('#config');
    var message = gadget.getMsg('gh.gadget.version.report.no.version.in.project');

    AJS.$(".button.save").removeAttr('disabled');
    $container.find('.aui-message').closeMessage();

    if(_.isEmpty(newVersionList)) {
        AJS.$(".button.save").attr('disabled', 'disabled');
        AJS.messages.warning($container, {autoHide: false, shadowed: false, closeable: false, body: message, insert: 'prepend'});
    }
    gadget.resize();
};
