GADGET = {GH: {}};

GADGET.boardInitialized = false;

GADGET.preInit = function(baseUrl) {
    // gadgets have a slightly different lifecycle/context because they're loaded in an iframe.
    // given that, we need to explicitly trigger the initialisation event when they load.
    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.trigger('pre-initialization');

    // redefine the context path
    GH.Ajax.CONTEXT_PATH = baseUrl;
};

GADGET.isWallboardMode = function() {
    return GH.gadget.utils.getViewName() == 'wallboard';
};

/**
 * Ajax requests for the template
 */
GADGET.templateArgs = function(baseUrl) {
    //Assign wallboard class here so errors also get this class in the body
    if (GADGET.isWallboardMode()) {
        AJS.$('body').addClass('wallboard');
    }
    return [];
};

/**
 * Gadget template function
 */
GADGET.template = function (gadget, args, baseUrl) {
    if (!GADGET.boardInitialized) {
        // initialize the actual rendering code
        GADGET.GH.init(gadget);
        GADGET.boardInitialized = true;
    }

    GADGET.GH.loadAndRender(gadget);
};

/**
 * Ajax requests to be executed for the descriptor
 */
GADGET.descriptorArgs = function(baseUrl) {
    return [
        {
            key: "rapidViews",
            ajaxOptions:  baseUrl + "/rest/greenhopper/1.0/rapidview"
        }
    ];
};

/**
 * Gadget descriptor
 */
GADGET.descriptor = function (gadget, args, baseUrl) {
    //[GHS-2677]
    //Root cause is that the existing content is not cleared when an error is added as a result of a gadget refresh
    //To fix this we hide existing content when this class is appended into the body
    //Calling descriptor should remove class indicating invalidness
    AJS.$("body").removeClass('config-unavailable');

    return  {
        action: baseUrl + "/rest/greenhopper/1.0/gadgets/rapidview/pool/validate.json",
        theme : function() {
            if (gadgets.window.getViewportDimensions().width < 450) {
                return "gdt top-label";
            } else {
                return "gdt";
            }
        }(),
        fields: [
            GH.gadget.rapid.fields.rapidViewPicker(gadget, "rapidViewId", _.where(args.rapidViews.views, {sprintSupportEnabled: true})),
            GH.gadget.fields.checkbox(gadget, "showRapidViewName", 'gh.gadget.userpref.showrvname.name', gadget.getPref('showRapidViewName') == 'true'),
            GH.gadget.rapid.fields.sprintPicker(gadget, 'sprintId', 'rapidViewId', true, GH.gadget.rapid.server.loadOpenSprintsByBoardId),
            GH.gadget.fields.checkbox(gadget, "showSprintName", 'gh.gadget.userpref.showspname.name', gadget.getPref('showSprintName') == 'true'),
            AJS.gadget.fields.nowConfigured()
        ]
    };
};

GADGET.GH.init = function(gadget) {
    gadget.ajaxErrorHandler.handle404 = AJS.$.noop;
};

/**
 * Loads the rapid view config for the selected board (rapid view).
 *
 * @return {AJS.$.Promise} a promise of rapid view data
 */
GADGET.GH.loadConfig = function(gadget) {
    var rapidViewId = parseInt(gadget.getPref("rapidViewId"), 10);
    return GH.gadget.rapid.server.loadConfigByBoardId(rapidViewId);
};

/**
 * Loads all sprints for the selected board (rapid view).
 *
 * @return {AJS.$.Promise} an AJAX promise of array. Sprint data is available at the first position in the array
 */
GADGET.GH.loadOpenSprints = function (gadget) {
    var rapidViewId = parseInt(gadget.getPref("rapidViewId"), 10);
    return GH.gadget.rapid.server.loadOpenSprintsByBoardId(rapidViewId);
};

GADGET.GH.loadRemainingDays = function(gadget, sprintId) {
    var rapidViewId = parseInt(gadget.getPref("rapidViewId"), 10);
    return GH.Ajax.get({
        url: '/gadgets/sprints/remainingdays',
        data: {rapidViewId: rapidViewId, sprintId: sprintId}
    },  'remainingDays');
};

GADGET.GH.loadAndRender = function(gadget) {
    // load rapid view data (name, etc)
    var loadConfigPromise = GADGET.GH.loadConfig(gadget)
        .fail(function() {
            GH.gadget.utils.showInlineWarning(gadget, gadget.getMsg('gh.gadget.common.error.can.not.find.board.or.nopermission'));
        });

    // all sprints (includes closed sprints!)
    var loadSprintsPromise = GADGET.GH.loadOpenSprints(gadget)
        .fail(function() {
            GH.gadget.utils.showInlineWarning(gadget, gadget.getMsg('gh.gadget.sprint.error.can.not.load.sprints'));
        });

    // continue when we get both results back
    AJS.$.when(loadConfigPromise, loadSprintsPromise).done(function(rapidViewData, sprintsData) {
        GADGET.GH.selectSprint(gadget, rapidViewData, sprintsData);
    });
};

/**
 * Selects the correct sprint to visualize, either the defined id or the next sprint in case of auto
 */
GADGET.GH.selectSprint = function(gadget, rapidViewData, openSprints) {
    // find the correct sprint
    var sprintId = parseInt(gadget.getPref("sprintId"), 10);
    if (_.isNaN(sprintId)) {
        sprintId  = 'auto';
    }

    var sprint;
    if (sprintId == 'auto') {
        sprint = _.first(openSprints);
    } else {
        sprint = _.findWhere(openSprints, {id: sprintId });
    }

    if (sprint) {
        GADGET.GH.loadRemainingDays(gadget, sprint.id).done(function(daysRemaining) {
            GADGET.GH.showChart(gadget, rapidViewData, sprint, daysRemaining);
        });
    } else if (sprintId === 'auto') {
        GH.gadget.utils.showInlineWarning(gadget, gadget.getMsg('gh.gadget.sprint.error.selected.sprint.not.active'));
    } else {
        GH.gadget.utils.showInlineWarning(gadget, gadget.getMsg('gh.gadget.sprint.error.can.not.find.sprint'));
    }
};

GADGET.GH.showChart = function(gadget, rapidViewData, sprintData, remainingData) {
    gadget.getView().html(GH.tpl.gadget.daysRemaining.render({
        days: remainingData.days
    }));

    var showRapidViewName = gadget.getPref("showRapidViewName") === 'true';
    var showSprintName = gadget.getPref("showSprintName") === 'true';

    gadget.getView().find("#ghx-remaining-header").html(GADGET.GH.getGadgetHeader(gadget, showRapidViewName, rapidViewData, showSprintName, sprintData));

    gadget.resize();
};

GADGET.GH.getGadgetHeader = function (gadget, showRapidViewName, rapidViewData, showSprintName, sprintData) {
    return GH.tpl.gadgets.renderBasicHeader({
        showTitle: showRapidViewName,
        showSubtitle: showSprintName,
        title: rapidViewData.name,
        subtitle: sprintData.name,
        subtitleLabel: gadget.getMsg('gh.gadget.sprint.burndown.sprint')
    });
};