define('jira-agile/dialog/labels-dialog', [
    'jira/dialog/labels-dialog'
],function(
    LabelsDialog
) {
    /**
     * The labels popup is a bit a special case, in that it implements some custom stuff on top of what formpopup provides.
     * First add our form extensions, then handle the additional stuff
     *
     * In short, the popup in-document replaces the labels instead of triggering a complete page refresh. That's what the
     * labelsProvider is used for. All magic is actually happening inside LabelsPopup.js/_handleSubmitResponse.
     *
     * Solution to this problem: Simply re-overwrite the function with the default implementation of FormPopup.
     */
    var AgileLabelsDialog = LabelsDialog.extend(GH.Dialog.baseExtension);
    AgileLabelsDialog = AgileLabelsDialog.extend(GH.Dialog.XBoardExtension);

    AgileLabelsDialog = AgileLabelsDialog.extend({
        _handleSubmitResponse: function (data, xhr, smartAjaxResult) {
            if (this.serverIsDone) {
                if (this.options.onSuccessfulSubmit) {
                    this.options.onSuccessfulSubmit.call(this, data, xhr, smartAjaxResult);
                }
                if (this.options.autoClose) {
                    this.hide();
                }
                if (this.options.onDialogFinished) {
                    this.options.onDialogFinished.call(this, data, xhr, smartAjaxResult);
                }
            }
        },

        /**
         * This function ensures that the keyboard shortcut hint is not displayed for custom fields
         */
        decorateContent: function() {
            this._super();

            var $content = this.get$popupContent();
            var $customFieldId = $content.find('input[name=customFieldId]');
            if ($customFieldId.length === 1) {
                var $hint = $content.find('#hint');
                $hint.hide();
            }
        }
    });

    return AgileLabelsDialog;
});