define('jira-agile/admin/lexorank/views/lexorank-management-view', ['require'], function (require) {
    const Backbone = require('backbone');
    const _ = require('underscore');
    const LexoRankManagementIntegrityView = require('jira-agile/admin/lexorank/views/lexorank-management-integrity-view');
    const LexoRankManagementBalanceView = require('jira-agile/admin/lexorank/views/lexorank-management-balance-view');

    return Backbone.View.extend({
        initialize(options) {
            _.extend(this, _.pick(options, 'service'));
            this.balanceView = new LexoRankManagementBalanceView({
                model: this.model,
                service: this.service
            });
            this.integrityView = new LexoRankManagementIntegrityView({
                model: this.model,
                service: this.service
            });
            this.render();
            this.service.refreshBalanceStatus();
        },

        render() {
            this.$el.html(GH.tpl.lexorankmanagement.renderMainLayout({}));
            this.balanceView.setElement(this.$('#js-lrmng-balance-status'));
            this.balanceView.render();
            this.integrityView.setElement(this.$('#js-lrmng-integrity-check'));
            this.integrityView.render();
        }
    });
});

AJS.namespace('GH.LexoRankManagementView', null, require('jira-agile/admin/lexorank/views/lexorank-management-view'));
