define('jira-agile/admin/lexorank/views/lexorank-management-integrity-view', ['require'], function (require) {
    const _ = require('underscore')
    const Backbone = require('backbone');
    const AuiMessages = require('aui/message');
    const UiUtils = GH.Util.UI;

    return Backbone.View.extend({
        events: {
            'click .js-lrmng-integrity-run-button': 'runIntegrity'
        },

        initialize(options) {
            _.extend(this, _.pick(options, 'service'));
            this.model.on('change:integrityCheck', this.render, this);
            this.model.on('change:integrityMessage', this.displayMessage, this);
            this.model.on('change:integrityCheckInProgress', this.enableControls, this);
        },

        render() {
            const integrityResult = this.model.get('integrityCheck');
            this.$el.html(GH.tpl.lexorankmanagement.renderIntegrityResult({integrityResult}));
            this.enableControls();
        },

        runIntegrity() {
            this.service.runIntegrity();
        },

        displayMessage() {
            const message = this.model.get('integrityMessage');
            if (message && message.error) {
                AuiMessages.error('#js-lrmng-integrity-message', {
                    body: message.error,
                    fadeout: true
                });
            } else if (message && message.success) {
                AuiMessages.success('#js-lrmng-integrity-message', {
                    body: message.success,
                    fadeout: true
                });
            }
            this.model.unset('integrityMessage');
        },

        enableControls() {
            if (this.model.get('integrityCheckInProgress')) {
                UiUtils.ariaDisable('.js-lrmng-integrity-run-button');
            } else {
                UiUtils.ariaEnable('.js-lrmng-integrity-run-button');
            }
        }
    });
});

AJS.namespace('GH.LexoRankManagementIntegrityView', null, require('jira-agile/admin/lexorank/views/lexorank-management-integrity-view'));
