define('jira-agile/admin/lexorank/services/lexorank-management-service', ['require'], function (require) {
    const formatter = require('jira/util/formatter');
    const Ajax = GH.Ajax;

    class LexoRankManagementService {
        constructor(model) {
            this.model = model;
        }

        refreshBalanceStatus() {
            this.model.set({
                balanceStatusInProgress: true,
                balanceMessage: undefined
            });

            Ajax.get({url: '/lexorank/balance'}, 'lexorankBalance')
                .done(response => {
                    response.timestamp = new Date();
                    this.model.set({
                        balanceStatusInProgress: false,
                        balanceStatus: response
                    });
                })
                .fail(() => this.model.set({
                    balanceStatusInProgress: false,
                    balanceStatus: {},
                    balanceMessage: {error: formatter.I18n.getText('gh.configuration.lexorank-manage.service.balance.error')}
                }));
        }

        requestBalanceAll() {
            this.model.set({
                balanceStatusInProgress: true,
                balanceMessage: undefined
            });

            Ajax.post({url: '/lexorank/balance'})
                .done(() => this.model.set({
                    balanceStatusInProgress: false,
                    balanceMessage: {success: formatter.I18n.getText('gh.configuration.lexorank-manage.service.balance.all.success')}
                }))
                .fail(() => this.model.set({
                    balanceStatusInProgress: false,
                    balanceMessage: {error: formatter.I18n.getText('gh.configuration.lexorank-manage.service.balance.all.error')}
                }));
        }

        requestBalanceField(fieldId) {
            this.model.set({
                balanceStatusInProgress: true,
                balanceMessage: undefined
            });

            Ajax.post({url: `/lexorank/balance?fieldId=${fieldId}`})
                .done(() => this.model.set({
                    balanceStatusInProgress: false,
                    balanceMessage: {success: formatter.I18n.getText('gh.configuration.lexorank-manage.service.balance.field.success', fieldId)}
                }))
                .fail(() => this.model.set({
                    balanceStatusInProgress: false,
                    balanceMessage: {error: formatter.I18n.getText('gh.configuration.lexorank-manage.service.balance.field.error', fieldId)}
                }));
        }

        runIntegrity() {
            this.model.set({
                integrityCheckInProgress: true,
                integrityMessage: undefined
            });

            Ajax.get({url: '/lexorank/integrity'}, 'integrityCheck')
                .done(response => {
                    response.timestamp = new Date();
                    this.model.set({
                        integrityCheckInProgress: false,
                        integrityCheck: response
                    });
                })
                .fail(() => this.model.set({
                    integrityCheckInProgress: false,
                    integrityMessage: {error: formatter.I18n.getText('gh.configuration.lexorank-manage.service.integrity.error')}
                }));
        };
    }

    return LexoRankManagementService;
});

AJS.namespace('GH.LexoRankManagementService', null, require('jira-agile/admin/lexorank/services/lexorank-management-service'));
