/* globals ok, AgileDashboardItem, module, sinon, equal, test */
AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common",
                  "com.pyxis.greenhopper.jira:dashboard-item-common-test-resources",
                  "com.pyxis.greenhopper.jira:greenhopper-sprint-health-dashboard-item-resources"],
    function() {

        var SprintHealthDashboardItem;

        //  Run tests only for JIRA 6.4+
        try {
            SprintHealthDashboardItem = require('jira-dashboard-items/sprint-health');
        } catch(err){
            console.log("Run tests only for JIRA 6.4+, erorr thrown:", err.message);
        }

        module('sprint health dashboard item tests', {

            setup: function () {

                this.server = sinon.fakeServer.create();

                var API = AJS.$.extend({}, AgileDashboardItem.Mocks.API);

                if (SprintHealthDashboardItem) {
                    this.dashboardItem = new SprintHealthDashboardItem(API);
                    this.element = AJS.$("<div/>");
                    this.element.append(GH.tpl.dashboardItems.sprintHealth.wrapper());
                }

            },

            teardown: function () {
                this.server.restore();
            }

        });


        if(typeof SprintHealthDashboardItem !== 'undefined') {
            var MOCK_BOARD_TYPES = {
                views: [
                    {
                        name: "Mock Board 1",
                        id: 1,
                        sprintSupportEnabled: true
                    },
                    {
                        name: "Mock Board 2",
                        id: 2,
                        sprintSupportEnabled: true
                    },
                    {
                        name: "Mock Board 3",
                        id: 3,
                        sprintSupportEnabled: false
                    },
                    {
                        name: "Mock Board 4",
                        id: 4,
                        sprintSupportEnabled: false
                    },
                    {
                        name: "Mock Board 5",
                        id: 5,
                        sprintSupportEnabled: false
                    }
                ]
            };

            var MOCK_ESTIMATION = {
                estimationStatistic: {
                    name: "Mock Statistic Type"
                }
            };

            var MOCK_TIMING = {
                timeBasedEstimation: true
            };

            var MOCK_ASSIGNEES = {
                "assignees": [
                    {
                        "name": "Mockery Jimbo",
                        "avatarUrl": "/path/to/dashing/photo"
                    }
                ]
            };

            var MOCK_BOARD_DATA = {
                currentViewConfig: AJS.$.extend({}, MOCK_BOARD_TYPES.views[0], MOCK_ESTIMATION)
            };

            var MOCK_SPRINT_TYPES_ONE = {
                sprints: [
                    {
                        name: "Mock Sprint 1.1",
                        id: 1,
                        state: "ACTIVE"
                    },
                    {
                        name: "Mock Sprint 1.2",
                        id: 2,
                        state: "ACTIVE"
                    },
                    {
                        name: "Mock Sprint 1.3",
                        id: 3,
                        state: "ACTIVE"
                    }
                ]
            };

            var MOCK_SPRINT_TYPES_TWO = {
                sprints: [
                    {
                        name: "Mock Sprint 2.1",
                        id: 1,
                        state: "ACTIVE"
                    },
                    {
                        name: "Mock Sprint 2.2",
                        id: 2,
                        state: "ACTIVE"
                    }
                ]
            };

            var MOCK_SPRINT_HEALTH_DATA = AJS.$.extend({}, GH.AjaxTest.Data.SprintHealth, MOCK_ASSIGNEES);

            var MOCK_SPRINT_HEALTH_DATA_WITH_TIMING_ENABLED = AJS.$.extend({}, MOCK_SPRINT_HEALTH_DATA, MOCK_TIMING);

            var MOCK_PREFERENCES = {
                isConfigured: true,
                rapidViewId: "1",
                refresh: false,
                showAssignees: true,
                showRapidViewName: true,
                showSprintName: true,
                sprintId: "2"
            };

            var CHANGE_PREFERENCES = AJS.$.extend({}, MOCK_PREFERENCES, {
                rapidViewId: "2",
                sprintId: "1"
            });

            test("Testing error message being shown if configuration has not already been set on render", function () {

                var element = this.element;
                var preferences = {
                    isConfigured: false
                };

                this.dashboardItem.render(element, preferences);

                var errorMessage = element.find(".aui-message").text();

                ok(errorMessage.length > 0, 'Found the error message div.');
                ok(errorMessage === "gh.gadget.sprint.error.selected.sprint.not.active", 'Correct error message/type shown.');
            });

            test("Testing error message being shown if user doesn't has software license", function() {
                var element = this.element;
                var preferences = MOCK_PREFERENCES;

                this.dashboardItem.render(element, preferences);
                this.server.requests[0].respond(403, { "Content-Type": "application/json" });

                var errorMessage = element.find(".aui-message");

                ok(errorMessage.length > 0, 'Found the error message within the div.');
            });

            test("Testing if the board types are populated correctly", function () {

                var element = this.element;
                var preferences = {};

                this.dashboardItem.renderEdit(element, preferences);
                this.server.requests[0].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_BOARD_TYPES));

                var allOptions = element.find("select[name=board-type] option");
                var optionOne = element.find("select[name=board-type] option:eq(0)").text();
                var optionTwo = element.find("select[name=board-type] option:eq(1)").text();

                ok(allOptions.length === 2, "The correct number of board types have been rendered/selected.");
                equal(optionOne, MOCK_BOARD_TYPES.views[0].name, "Options rendered correctly - option one has been mocked correctly.");
                equal(optionTwo, MOCK_BOARD_TYPES.views[1].name, "Options rendered correctly - option two has been mocked correctly.");

            });

            test("Testing if selecting 'auto' in the sprint selection is correctly handled", function () {

                var element = this.element;
                var preferences = {};
                var savePreferencesSpy = sinon.spy();
                sinon.stub(this.dashboardItem.API, "savePreferences", savePreferencesSpy);

                this.dashboardItem.renderEdit(element, preferences);
                this.server.requests[0].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_BOARD_TYPES));

                var sprintPicker = element.find("select[name=sprint-type]");
                var boardPicker = element.find("select[name=board-type]");
                var form = element.find("form");

                boardPicker.find("option:eq(0)").prop("selected", true);
                boardPicker.trigger("change");

                this.server.requests[1].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_SPRINT_TYPES_ONE));

                sprintPicker.find("option:eq(0)").prop("selected", true);

                form.trigger("submit");

                //  New preferences have been saved
                ok(savePreferencesSpy.calledOnce, "Preferences have been saved.");

                //  Reflect these changes
                preferences = AJS.$.extend({}, preferences, {
                    sprintId: sprintPicker.find("option:selected").val()
                });

                ok(preferences.sprintId === 'gh.gadget.auto', "'auto' sprint selection works correctly.");
            });


            test("Testing if sprint types are populated correctly", function () {

                var element = this.element;
                var preferences = {};

                var allSprintOptions, optionOne, optionTwo, optionThree, optionFour;

                this.dashboardItem.renderEdit(element, preferences);
                this.server.requests[0].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_BOARD_TYPES));

                var sprintPicker = element.find("select[name=sprint-type]");
                var boardPicker = element.find("select[name=board-type]");

                boardPicker.find("option:eq(0)").prop("selected", true);
                boardPicker.trigger("change");

                this.server.requests[1].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_SPRINT_TYPES_ONE));

                allSprintOptions = sprintPicker.find("option");
                optionOne = sprintPicker.find("option:eq(0)").text();
                optionTwo = sprintPicker.find("option:eq(1)").text();
                optionThree = sprintPicker.find("option:eq(2)").text();
                optionFour = sprintPicker.find("option:eq(3)").text();

                ok(allSprintOptions.length == 4, "The correct number of sprints have been rendered/selected for Mock Board 1.");
                equal(optionOne, "gh.gadget.sprint.option.auto", "Options rendered correctly - auto sprint option has been mocked correctly.");
                equal(optionTwo, MOCK_SPRINT_TYPES_ONE.sprints[0].name, "Options rendered correctly - option one has been mocked correctly.");
                equal(optionThree, MOCK_SPRINT_TYPES_ONE.sprints[1].name, "Options rendered correctly - option two has been mocked correctly.");
                equal(optionFour, MOCK_SPRINT_TYPES_ONE.sprints[2].name, "Options rendered correctly - option three has been mocked correctly.");

                boardPicker.find("option:eq(1)").prop("selected", true);
                boardPicker.trigger("change");

                this.server.requests[2].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_SPRINT_TYPES_TWO));

                allSprintOptions = element.find("select[name=sprint-type] option");
                optionOne = element.find("select[name=sprint-type] option:eq(0)").text();
                optionTwo = element.find("select[name=sprint-type] option:eq(1)").text();
                optionThree = element.find("select[name=sprint-type] option:eq(2)").text();

                ok(allSprintOptions.length == 3, "The correct number of sprints have been rendered/selected for Mock Board 2.");
                equal(optionOne, "gh.gadget.sprint.option.auto", "Options rendered correctly - auto sprint option has been mocked correctly.");
                equal(optionTwo, MOCK_SPRINT_TYPES_TWO.sprints[0].name, "Options rendered correctly - option one has been mocked correctly.");
                equal(optionThree,  MOCK_SPRINT_TYPES_TWO.sprints[1].name, "Options rendered correctly - option two has been mocked correctly.");

            });

            test("Testing preferences are being saved and applied when form is submitted", function () {

                var element = this.element;
                var preferences = MOCK_PREFERENCES;

                var savePreferencesSpy = sinon.spy();
                sinon.stub(this.dashboardItem.API, "savePreferences", savePreferencesSpy);

                //  Will render edit mode with mock params.
                this.dashboardItem.renderEdit(element, preferences);
                this.server.requests[0].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_BOARD_TYPES));

                //  Now introduce some changes to these params (change rapidViewId to 2, and sprintId to 1).
                var expectedPreferences = AJS.$.extend({}, preferences, CHANGE_PREFERENCES);

                //  Reflect these changes in the DOM.
                var form = element.find("form");
                var sprintPicker = element.find("select[name=sprint-type]");
                var boardPicker = element.find("select[name=board-type]");

                boardPicker.find("option:eq(1)").prop("selected", true);
                boardPicker.trigger("change");

                this.server.requests[1].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_SPRINT_TYPES_TWO));

                sprintPicker.find("option:eq(1)").prop("selected", true);
                form.trigger("submit");

                //  Check if the preferences have been saved (they should be).
                ok(savePreferencesSpy.calledOnce, "Preferences have been saved.");

                //  Update the preferences object to reflect the state of the config view in the DOM.
                preferences = AJS.$.extend({}, preferences, {
                    rapidViewId: boardPicker.find("option:selected").val(),
                    sprintId: sprintPicker.find("option:selected").val()
                });

                //  Test passes if the preferences object has been successfully updated.
                deepEqual(preferences, expectedPreferences, "Preferences correctly changed.");

            });

            test("Testing boolean checkboxes and hiding/showing of names/assignees", function () {

                var element = this.element;

                //  Set up a preferences object where showSprintName = true, showAssignees = true, showRapidViewName = false.
                var mixedShowPreferences = AJS.$.extend({}, MOCK_PREFERENCES, {
                    showRapidViewName: false
                });

                this.dashboardItem.render(element, mixedShowPreferences);

                this.server.requests[0].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_SPRINT_HEALTH_DATA));
                this.server.requests[1].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_BOARD_DATA));

                //  Search the DOM for the three elements.
                var showSprintName = element.find("span.ag-name-sprint").length > 0;
                var showRapidViewName = element.find("span.ag-name-board").length > 0;
                var showAssignees = element.find("span.ag-avatar").length > 0;

                ok(showSprintName === true, "showSprintName bool correctly set.");
                ok(showRapidViewName === false, "showRapidViewName bool correctly set.");
                ok(showAssignees === true, "showAssignees bool correctly set.");

            });

            test("Testing if timeBasedEstimationStatistic being true, calls the correct resolver functions", function () {

                var element = this.element;
                var preferences = MOCK_PREFERENCES;

                var timeFormatSpy = sinon.spy();
                sinon.stub(GH.TimeFormat, "formatShortDurationForTimeTrackingConfiguration", timeFormatSpy);

                this.dashboardItem.render(element, preferences);

                this.server.requests[0].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_SPRINT_HEALTH_DATA_WITH_TIMING_ENABLED));
                this.server.requests[1].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_BOARD_DATA));

                ok(timeFormatSpy.called, "Time-formatting succeeded.");

            });

            test("Testing if width of graph is correct", function () {

                var element = this.element;
                var preferences = MOCK_PREFERENCES;

                this.dashboardItem.render(element, preferences);

                this.server.requests[0].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_SPRINT_HEALTH_DATA));
                this.server.requests[1].respond(200, {"Content-Type": "application/json"}, JSON.stringify(MOCK_BOARD_DATA));

                //  Get the width of the three graph params - todo, progress, done
                var toDoWidth = element.find(".ag-todo").width();
                var progressWidth = element.find(".ag-inprogress").width();
                var doneWidth = element.find(".ag-done").width();

                ok(toDoWidth === 10, "To-do width is correct.");
                ok(progressWidth === 40, "Progress width is correct.");
                ok(doneWidth === 50, "Done width is correct.");

            });

            test("Testing gadget auto refresh", function () {
                this.stub(this.dashboardItem.API, "initRefresh");

                var element = this.element;
                var preferences = MOCK_PREFERENCES;

                this.dashboardItem.render(element, preferences);
                ok(this.dashboardItem.API.initRefresh.called, "Gadget should call initRefresh()");

            });

            test('refresh in preferences should be false in case auto-refresh unchecked', function(){
                var element = this.element;

                //  Render edit mode with mock params
                this.dashboardItem.renderEdit(element, MOCK_PREFERENCES);
                this.server.requests[0].respond(200, {'Content-Type': 'application/json'}, JSON.stringify(MOCK_BOARD_TYPES));

                AJS.$(this.dashboardItem.sprintHealthView).on('submit', function(e, preferences) {
                    ok(preferences.refresh === false);
                });
                element.find('form').trigger('submit');
            });

        } else {

            test("Make test pass in JIRA <6.4", function(){
                ok(true);
            });

        }
    }
);
